/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.block;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.cookingforblockheads.ItemUtils;
import net.blay09.mods.cookingforblockheads.block.BlockDyeableKitchen;
import net.blay09.mods.cookingforblockheads.block.ModBlocks;
import net.blay09.mods.cookingforblockheads.item.ModItems;
import net.blay09.mods.cookingforblockheads.tile.FridgeBlockEntity;
import net.blay09.mods.cookingforblockheads.tile.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class FridgeBlock
extends BlockDyeableKitchen {
    public static final String name = "fridge";
    public static final ResourceLocation registryName = new ResourceLocation("cookingforblockheads", "fridge");
    public static final EnumProperty<FridgeModelType> MODEL_TYPE = EnumProperty.m_61587_((String)"model", FridgeModelType.class);
    public static final BooleanProperty PRESERVATION_CHAMBER = BooleanProperty.m_61465_((String)"preservation_chamber");
    public static final BooleanProperty ICE_UNIT = BooleanProperty.m_61465_((String)"ice_unit");

    public FridgeBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_278166_(PushReaction.BLOCK).m_60918_(SoundType.f_56743_).m_60913_(5.0f, 10.0f), registryName);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)PRESERVATION_CHAMBER, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ICE_UNIT, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, MODEL_TYPE, FLIPPED, PRESERVATION_CHAMBER, ICE_UNIT, COLOR, HAS_COLOR});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new FridgeBlockEntity(pos, state);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
        ItemStack heldItem = player.m_21120_(hand);
        if (heldItem.m_41720_() == ModItems.preservationChamber || heldItem.m_41720_() == ModItems.iceUnit) {
            return InteractionResult.PASS;
        }
        if (this.tryRecolorBlock(state, heldItem, level, pos, player, rayTraceResult)) {
            return InteractionResult.SUCCESS;
        }
        FridgeBlockEntity fridge = (FridgeBlockEntity)level.m_7702_(pos);
        Direction frontFace = (Direction)state.m_61143_((Property)FACING);
        if (rayTraceResult.m_82434_() == frontFace && fridge != null) {
            if (player.m_6144_()) {
                fridge.getBaseFridge().getDoorAnimator().toggleForcedOpen();
                return InteractionResult.SUCCESS;
            }
            if (!heldItem.m_41619_() && fridge.getBaseFridge().getDoorAnimator().isForcedOpen()) {
                heldItem = fridge.insertItemStacked(heldItem, false);
                player.m_21008_(hand, heldItem);
                return InteractionResult.SUCCESS;
            }
        }
        if (!level.f_46443_) {
            if (!heldItem.m_41619_() && Block.m_49814_((Item)heldItem.m_41720_()) instanceof FridgeBlock && rayTraceResult.m_82434_() != frontFace) {
                return InteractionResult.FAIL;
            }
            Balm.getNetworking().openGui(player, (MenuProvider)fridge);
        }
        return InteractionResult.SUCCESS;
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        boolean below = level.m_8055_(pos.m_7495_()).m_60734_() instanceof FridgeBlock;
        boolean above = level.m_8055_(pos.m_7494_()).m_60734_() instanceof FridgeBlock;
        return !(below && above || below && level.m_8055_(pos.m_6625_(2)).m_60734_() instanceof FridgeBlock || above && level.m_8055_(pos.m_6630_(2)).m_60734_() instanceof FridgeBlock || !super.m_7898_(state, level, pos));
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = super.m_5573_(context);
        return (BlockState)state.m_61124_((Property)FLIPPED, (Comparable)Boolean.valueOf(this.shouldBePlacedFlipped(context, (Direction)state.m_61143_((Property)FACING))));
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        BlockPos posBelow = currentPos.m_7495_();
        BlockState stateBelow = world.m_8055_(posBelow);
        BlockPos posAbove = currentPos.m_7494_();
        BlockState stateAbove = world.m_8055_(posAbove);
        if (stateBelow.m_60734_() == ModBlocks.fridge && stateBelow.m_61143_(MODEL_TYPE) == FridgeModelType.SMALL) {
            world.m_7731_(posBelow, (BlockState)((BlockState)stateBelow.m_61124_(MODEL_TYPE, (Comparable)((Object)FridgeModelType.LARGE_LOWER))).m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING))), 3);
            return (BlockState)state.m_61124_(MODEL_TYPE, (Comparable)((Object)FridgeModelType.LARGE_UPPER));
        }
        if (stateAbove.m_60734_() == ModBlocks.fridge && stateAbove.m_61143_(MODEL_TYPE) == FridgeModelType.SMALL) {
            world.m_7731_(posAbove, (BlockState)((BlockState)stateAbove.m_61124_(MODEL_TYPE, (Comparable)((Object)FridgeModelType.LARGE_UPPER))).m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING))), 3);
            return (BlockState)state.m_61124_(MODEL_TYPE, (Comparable)((Object)FridgeModelType.LARGE_LOWER));
        }
        return super.m_7417_(state, facing, facingState, world, currentPos, facingPos);
    }

    @Override
    protected boolean isDyeable() {
        return true;
    }

    @Override
    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof FridgeBlockEntity) {
                if (((FridgeBlockEntity)blockEntity).hasIceUpgrade()) {
                    ItemUtils.spawnItemStack(level, (float)pos.m_123341_() + 0.5f, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, new ItemStack((ItemLike)ModItems.iceUnit));
                }
                if (((FridgeBlockEntity)blockEntity).hasPreservationUpgrade()) {
                    ItemUtils.spawnItemStack(level, (float)pos.m_123341_() + 0.5f, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, new ItemStack((ItemLike)ModItems.preservationChamber));
                }
            }
            BlockPos posAbove = pos.m_7494_();
            BlockState stateAbove = level.m_8055_(posAbove);
            BlockPos posBelow = pos.m_7495_();
            BlockState stateBelow = level.m_8055_(posBelow);
            if (stateAbove.m_60734_() == ModBlocks.fridge && stateAbove.m_61143_(MODEL_TYPE) == FridgeModelType.LARGE_UPPER) {
                level.m_7731_(posAbove, (BlockState)stateAbove.m_61124_(MODEL_TYPE, (Comparable)((Object)FridgeModelType.SMALL)), 3);
            } else if (stateBelow.m_60734_() == ModBlocks.fridge && stateBelow.m_61143_(MODEL_TYPE) == FridgeModelType.LARGE_LOWER) {
                level.m_7731_(posBelow, (BlockState)stateBelow.m_61124_(MODEL_TYPE, (Comparable)((Object)FridgeModelType.SMALL)), 3);
            }
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return level.f_46443_ ? FridgeBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.fridge.get()), FridgeBlockEntity::clientTick) : FridgeBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.fridge.get()), FridgeBlockEntity::serverTick);
    }

    @Override
    protected boolean recolorBlock(BlockState state, LevelAccessor world, BlockPos pos, Direction facing, DyeColor color) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof FridgeBlockEntity) {
            FridgeBlockEntity fridge = (FridgeBlockEntity)blockEntity;
            BlockPos bottomPos = fridge.getBaseFridge().m_58899_();
            BlockPos topPos = bottomPos.m_7494_();
            return super.recolorBlock(world.m_8055_(bottomPos), world, bottomPos, facing, color) && super.recolorBlock(world.m_8055_(topPos), world, topPos, facing, color);
        }
        return false;
    }

    public static enum FridgeModelType implements StringRepresentable
    {
        SMALL,
        LARGE_LOWER,
        LARGE_UPPER;


        public String m_7912_() {
            return this.name().toLowerCase();
        }
    }
}

