/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.charginggadgets.blocks.chargingstation;

import com.direwolf20.charginggadgets.Config;
import com.direwolf20.charginggadgets.blocks.BlockRegistry;
import com.direwolf20.charginggadgets.blocks.chargingstation.ChargingStationContainer;
import com.direwolf20.charginggadgets.capabilities.ChargerEnergyStorage;
import com.direwolf20.charginggadgets.capabilities.ChargerItemHandler;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.ItemStackHandler;

public class ChargingStationTile
extends BlockEntity
implements MenuProvider {
    private int counter = 0;
    private int maxBurn = 0;
    public ChargerEnergyStorage energyStorage;
    private LazyOptional<ChargerEnergyStorage> energy;
    private LazyOptional<ItemStackHandler> inventory = LazyOptional.of(() -> new ChargerItemHandler(this));
    public final ContainerData chargingStationData = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> ChargingStationTile.this.energyStorage.getEnergyStored() / 32;
                case 1 -> ChargingStationTile.this.energyStorage.getMaxEnergyStored() / 32;
                case 2 -> ChargingStationTile.this.counter;
                case 3 -> ChargingStationTile.this.maxBurn;
                default -> throw new IllegalArgumentException("Invalid index: " + index);
            };
        }

        public void m_8050_(int index, int value) {
            throw new IllegalStateException("Cannot set values through IIntArray");
        }

        public int m_6499_() {
            return 4;
        }
    };

    public ChargingStationTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockRegistry.CHARGING_STATION_TILE.get(), pos, state);
        this.energyStorage = new ChargerEnergyStorage(this, 0, (Integer)Config.GENERAL.chargerMaxPower.get());
        this.energy = LazyOptional.of(() -> this.energyStorage);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
        assert (this.f_58857_ != null);
        return new ChargingStationContainer(this, this.chargingStationData, i, playerInventory, (ItemStackHandler)this.inventory.orElse((Object)new ItemStackHandler(2)));
    }

    public static <T extends BlockEntity> void ticker(Level level, BlockPos blockPos, BlockState state, T t) {
        if (t instanceof ChargingStationTile) {
            ChargingStationTile entity = (ChargingStationTile)t;
            entity.inventory.ifPresent(handler -> {
                entity.tryBurn();
                ItemStack stack = handler.getStackInSlot(Slots.CHARGE.id);
                if (!stack.m_41619_()) {
                    entity.chargeItem(stack);
                }
            });
        }
    }

    private void chargeItem(ItemStack stack) {
        this.getCapability(ForgeCapabilities.ENERGY).ifPresent(energyStorage -> stack.getCapability(ForgeCapabilities.ENERGY).ifPresent(itemEnergy -> {
            if (!this.isChargingItem((IEnergyStorage)itemEnergy)) {
                return;
            }
            int energyRemoved = itemEnergy.receiveEnergy(Math.min(energyStorage.getEnergyStored(), 2500), false);
            ((ChargerEnergyStorage)energyStorage).consumeEnergy(energyRemoved, false);
        }));
    }

    public boolean isChargingItem(IEnergyStorage energy) {
        return energy.getEnergyStored() >= 0 && energy.receiveEnergy(energy.getEnergyStored(), true) >= 0;
    }

    private void tryBurn() {
        if (this.f_58857_ == null) {
            return;
        }
        this.getCapability(ForgeCapabilities.ENERGY).ifPresent(energyStorage -> {
            boolean canInsertEnergy;
            boolean bl = canInsertEnergy = energyStorage.receiveEnergy(625, true) > 0;
            if (this.counter > 0 && canInsertEnergy) {
                this.burn((IEnergyStorage)energyStorage);
            } else if (canInsertEnergy && this.initBurn()) {
                this.burn((IEnergyStorage)energyStorage);
            }
        });
    }

    private void burn(IEnergyStorage energyStorage) {
        energyStorage.receiveEnergy(625, false);
        --this.counter;
        if (this.counter == 0) {
            this.maxBurn = 0;
            this.initBurn();
        }
    }

    private boolean initBurn() {
        ItemStackHandler handler = (ItemStackHandler)this.inventory.orElseThrow(RuntimeException::new);
        ItemStack stack = handler.getStackInSlot(Slots.FUEL.id);
        int burnTime = ForgeHooks.getBurnTime((ItemStack)stack, (RecipeType)RecipeType.f_44108_);
        if (burnTime > 0) {
            Item fuelStack = handler.getStackInSlot(Slots.FUEL.id).m_41720_();
            handler.extractItem(0, 1, false);
            if (fuelStack instanceof BucketItem && fuelStack != Items.f_42446_) {
                handler.insertItem(0, new ItemStack((ItemLike)Items.f_42446_, 1), false);
            }
            this.m_6596_();
            this.maxBurn = this.counter = (int)Math.floor(burnTime) / 50;
            return true;
        }
        return false;
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.inventory.ifPresent(h -> h.deserializeNBT(compound.m_128469_("inv")));
        this.energy.ifPresent(h -> h.deserializeNBT(compound.m_128469_("energy")));
        this.counter = compound.m_128451_("counter");
        this.maxBurn = compound.m_128451_("maxburn");
    }

    public void m_183515_(CompoundTag compound) {
        this.inventory.ifPresent(h -> compound.m_128365_("inv", (Tag)h.serializeNBT()));
        this.energy.ifPresent(h -> compound.m_128365_("energy", (Tag)h.serializeNBT()));
        compound.m_128405_("counter", this.counter);
        compound.m_128405_("maxburn", this.maxBurn);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.inventory.cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.energy.cast();
        }
        return super.getCapability(cap, side);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, entity -> this.m_5995_());
    }

    public CompoundTag m_5995_() {
        CompoundTag compoundTag = new CompoundTag();
        this.m_183515_(compoundTag);
        return compoundTag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    public void m_7651_() {
        this.energy.invalidate();
        this.inventory.invalidate();
        super.m_7651_();
    }

    public Component m_5446_() {
        return Component.m_237113_((String)"Charging Station Tile");
    }

    public static enum Slots {
        FUEL(0),
        CHARGE(1);

        int id;

        private Slots(int number) {
            this.id = number;
        }

        public int getId() {
            return this.id;
        }
    }
}

