/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.content.track.rails;

import de.melanx.utilitix.block.ModProperties;
import de.melanx.utilitix.content.track.TrackUtil;
import de.melanx.utilitix.content.track.carts.Cart;
import de.melanx.utilitix.content.track.rails.BlockPoweredRail;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;
import org.moddingx.libx.mod.ModX;

public abstract class BlockDirectionalRail
extends BlockPoweredRail {
    public BlockDirectionalRail(ModX mod, double maxRailSpeed, BlockBehaviour.Properties properties) {
        super(mod, maxRailSpeed, properties);
    }

    public BlockDirectionalRail(ModX mod, double maxRailSpeed, BlockBehaviour.Properties properties, Item.Properties itemProperties) {
        super(mod, maxRailSpeed, properties, itemProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ModProperties.REVERSE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{ModProperties.REVERSE});
    }

    public BlockState m_5573_(@Nonnull BlockPlaceContext context) {
        BlockState state = super.m_5573_(context);
        if (state == null) {
            return null;
        }
        Direction direction = context.m_8125_();
        Pair<RailShape, Boolean> properties = TrackUtil.getForPlacement(direction);
        return (BlockState)((BlockState)state.m_61124_(this.m_7978_(), (Comparable)((RailShape)properties.getLeft()))).m_61124_((Property)ModProperties.REVERSE, (Comparable)((Boolean)properties.getRight()));
    }

    @Override
    public void onMinecartPass(BlockState state, Level level, BlockPos pos, AbstractMinecart cart) {
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_)).booleanValue()) {
            Direction dir = TrackUtil.getFace((RailShape)state.m_61143_(this.m_7978_()), (Boolean)state.m_61143_((Property)ModProperties.REVERSE));
            Vec3 motion = cart.m_20184_();
            boolean movingWrongly = false;
            if (dir.m_122434_() == Direction.Axis.X) {
                movingWrongly = motion.f_82479_ != 0.0 && motion.f_82479_ > 0.0 != dir.m_122429_() > 0;
            } else if (dir.m_122434_() == Direction.Axis.Z) {
                boolean bl = motion.f_82481_ != 0.0 && motion.f_82481_ > 0.0 != dir.m_122431_() > 0 ? true : (movingWrongly = false);
            }
            if (movingWrongly) {
                cart.m_20334_((double)dir.m_122429_() * (this.maxRailSpeed / 5.0), 0.0, (double)dir.m_122431_() * (this.maxRailSpeed / 10.0));
            } else {
                if (Cart.getHorizontalDistanceSqr(motion) < this.maxRailSpeed / 10.0 * (this.maxRailSpeed / 10.0)) {
                    cart.m_20334_((double)dir.m_122429_() * (this.maxRailSpeed / 5.0), 0.0, (double)dir.m_122431_() * (this.maxRailSpeed / 5.0));
                }
                TrackUtil.accelerateStraight(level, pos, (RailShape)state.m_61143_(this.m_7978_()), cart, Cart.getHorizontalDistanceSqr(motion) < this.maxRailSpeed / 5.0 ? 1.5 * this.maxRailSpeed : this.maxRailSpeed);
            }
        } else {
            TrackUtil.slowDownCart(level, cart, this.maxRailSpeed);
        }
    }
}

