/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.content.backpack;

import de.melanx.utilitix.UtilitiXConfig;
import de.melanx.utilitix.content.backpack.BackpackMenu;
import de.melanx.utilitix.registration.ModItems;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.apache.commons.lang3.tuple.Pair;
import org.moddingx.libx.base.ItemBase;
import org.moddingx.libx.inventory.BaseItemStackHandler;
import org.moddingx.libx.mod.ModX;

public class ItemBackpack
extends ItemBase
implements DyeableLeatherItem {
    public static final Predicate<ItemStack> SLOT_VALIDATOR = item -> !(item.m_41720_() instanceof ItemBackpack);

    public ItemBackpack(ModX mod, Item.Properties properties) {
        super(mod, properties);
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level level, @Nonnull Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!level.f_46443_) {
            AtomicReference<Object> handler = new AtomicReference<Object>(null);
            handler.set(BaseItemStackHandler.builder((int)ItemBackpack.slotSize(stack)).contentsChanged(slot -> {
                stack.m_41784_().m_128365_("Items", (Tag)((BaseItemStackHandler)handler.get()).serializeNBT());
                player.m_21008_(hand, stack);
            }).validator(SLOT_VALIDATOR, new int[0]).build());
            if (!ItemBackpack.isEmpty(stack)) {
                ((BaseItemStackHandler)handler.get()).deserializeNBT(stack.m_41784_().m_128469_("Items"));
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                BackpackMenu.open(serverPlayer, handler.get(), stack);
            }
            return InteractionResultHolder.m_19092_((Object)stack, (boolean)false);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public boolean m_142095_() {
        return false;
    }

    public boolean m_142305_(@Nonnull ItemStack stack, @Nonnull ItemStack other, @Nonnull Slot slot, @Nonnull ClickAction action, @Nonnull Player player, @Nonnull SlotAccess access) {
        if (stack.m_41613_() != 1) {
            return false;
        }
        if (action != ClickAction.SECONDARY || !slot.m_150651_(player)) {
            return false;
        }
        if (!other.m_150930_(ModItems.backpack)) {
            return false;
        }
        boolean upgraded = this.upgrade(stack, other);
        if (upgraded) {
            player.m_5496_(SoundEvents.f_184215_, 0.8f, 0.8f + player.m_9236_().f_46441_.m_188501_() * 0.4f);
            other.m_41774_(1);
        }
        return upgraded;
    }

    @Nullable
    private static IItemHandlerModifiable getInventory(ItemStack stack) {
        if (!stack.m_41782_() || !stack.m_41784_().m_128441_("Items")) {
            return null;
        }
        AtomicReference<Object> handler = new AtomicReference<Object>(null);
        handler.set(BaseItemStackHandler.builder((int)ItemBackpack.slotSize(stack)).contentsChanged(slot -> stack.m_41784_().m_128365_("Items", (Tag)((BaseItemStackHandler)handler.get()).serializeNBT())).validator(SLOT_VALIDATOR, new int[0]).build());
        ((BaseItemStackHandler)handler.get()).deserializeNBT(stack.m_41784_().m_128469_("Items"));
        return handler.get();
    }

    public static boolean isEmpty(ItemStack stack) {
        IItemHandlerModifiable inventory = ItemBackpack.getInventory(stack);
        if (inventory != null) {
            for (int i = 0; i < inventory.getSlots(); ++i) {
                ItemStack itemStack = inventory.extractItem(i, 1, true);
                if (itemStack.m_41619_()) continue;
                return false;
            }
        }
        return true;
    }

    public boolean upgrade(ItemStack backpack, ItemStack otherBackpack) {
        int otherBackpackSlots;
        int backpackSlots = ItemBackpack.slotSize(backpack);
        if (backpackSlots + (otherBackpackSlots = ItemBackpack.slotSize(otherBackpack)) > UtilitiXConfig.Backpack.maxSize) {
            return false;
        }
        HashSet<Pair<Integer, ItemStack>> totalSlots = new HashSet<Pair<Integer, ItemStack>>(ItemBackpack.getSlots(backpack));
        for (Pair<Integer, ItemStack> slot : ItemBackpack.getSlots(otherBackpack)) {
            totalSlots.add((Pair<Integer, ItemStack>)Pair.of((Object)((Integer)slot.getLeft() + backpackSlots), (Object)((ItemStack)slot.getRight())));
        }
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("Size", backpackSlots + otherBackpackSlots);
        tag.m_128365_("Items", (Tag)ItemBackpack.createSlots(totalSlots));
        backpack.m_41784_().m_128365_("Items", (Tag)tag);
        ItemBackpack.combineDyeableItemColors(backpack, otherBackpack);
        return true;
    }

    public static int slotSize(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128425_("Items", 10)) {
            return UtilitiXConfig.Backpack.slotSize;
        }
        CompoundTag items = tag.m_128469_("Items");
        if (!items.m_128425_("Size", 99)) {
            return UtilitiXConfig.Backpack.slotSize;
        }
        return items.m_128451_("Size");
    }

    private static ListTag createSlots(Set<Pair<Integer, ItemStack>> slots) {
        ListTag list = new ListTag();
        for (Pair<Integer, ItemStack> slot : slots) {
            CompoundTag itemTag = new CompoundTag();
            itemTag.m_128405_("Slot", ((Integer)slot.getLeft()).intValue());
            ((ItemStack)slot.getRight()).m_41739_(itemTag);
            list.add((Object)itemTag);
        }
        return list;
    }

    private static Set<Pair<Integer, ItemStack>> getSlots(ItemStack backpack) {
        CompoundTag tag = backpack.m_41784_();
        if (!tag.m_128425_("Items", 10)) {
            return Set.of();
        }
        HashSet<Pair<Integer, ItemStack>> slots = new HashSet<Pair<Integer, ItemStack>>();
        CompoundTag items = tag.m_128469_("Items");
        ListTag tagList = items.m_128437_("Items", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag itemTags = tagList.m_128728_(i);
            int slot = itemTags.m_128451_("Slot");
            slots.add((Pair<Integer, ItemStack>)Pair.of((Object)slot, (Object)ItemStack.m_41712_((CompoundTag)itemTags)));
        }
        return slots;
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level level, @Nonnull List<Component> tooltipComponents, @Nonnull TooltipFlag isAdvanced) {
        if (isAdvanced.m_7050_()) {
            tooltipComponents.add((Component)Component.m_237110_((String)(this.m_5524_() + ".slots"), (Object[])new Object[]{ItemBackpack.slotSize(stack)}).m_130940_(ChatFormatting.GRAY));
        }
    }

    private static void combineDyeableItemColors(ItemStack stack, ItemStack other) {
        float b;
        float g;
        float r;
        int color;
        DyeableLeatherItem backpack;
        Item item;
        block7: {
            block6: {
                item = stack.m_41720_();
                if (!(item instanceof DyeableLeatherItem)) break block6;
                backpack = (DyeableLeatherItem)item;
                item = other.m_41720_();
                if (item instanceof DyeableLeatherItem) break block7;
            }
            return;
        }
        DyeableLeatherItem otherBackpack = (DyeableLeatherItem)item;
        int[] total = new int[3];
        int maxTotal = 0;
        int count = 0;
        if (backpack.m_41113_(stack)) {
            color = backpack.m_41121_(stack);
            r = (float)(color >> 16 & 0xFF) / 255.0f;
            g = (float)(color >> 8 & 0xFF) / 255.0f;
            b = (float)(color & 0xFF) / 255.0f;
            maxTotal += (int)(Math.max(r, Math.max(g, b)) * 255.0f);
            total[0] = total[0] + (int)(r * 255.0f);
            total[1] = total[1] + (int)(g * 255.0f);
            total[2] = total[2] + (int)(b * 255.0f);
            ++count;
        }
        if (otherBackpack.m_41113_(other)) {
            color = otherBackpack.m_41121_(other);
            r = (float)(color >> 16 & 0xFF) / 255.0f;
            g = (float)(color >> 8 & 0xFF) / 255.0f;
            b = (float)(color & 0xFF) / 255.0f;
            maxTotal += (int)(Math.max(r, Math.max(g, b)) * 255.0f);
            total[0] = total[0] + (int)(r * 255.0f);
            total[1] = total[1] + (int)(g * 255.0f);
            total[2] = total[2] + (int)(b * 255.0f);
            ++count;
        }
        if (count == 0) {
            return;
        }
        int r2 = total[0] / count;
        int g2 = total[1] / count;
        int b2 = total[2] / count;
        float average = (float)maxTotal / (float)count;
        float max = Math.max(r2, Math.max(g2, b2));
        r2 = (int)((float)r2 * average / max);
        g2 = (int)((float)g2 * average / max);
        b2 = (int)((float)b2 * average / max);
        int color2 = (r2 << 8) + g2;
        color2 = (color2 << 8) + b2;
        backpack.m_41115_(stack, color2);
    }
}

