/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.multipiston.network;

import com.ldtteam.multipiston.MultiPiston;
import com.ldtteam.multipiston.network.IMessage;
import com.ldtteam.multipiston.network.MultiPistonChangeMessage;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class NetworkChannel {
    private static final String LATEST_PROTO_VER = "1.0";
    private static final String ACCEPTED_PROTO_VERS = "1.0";
    private final SimpleChannel rawChannel;

    public NetworkChannel(String channelName) {
        this.rawChannel = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("multipiston", channelName), () -> "1.0", "1.0"::equals, "1.0"::equals);
    }

    public void registerCommonMessages() {
        int idx = 0;
        this.registerMessage(++idx, MultiPistonChangeMessage.class);
    }

    private <MSG extends IMessage> void registerMessage(int id, Class<MSG> msgClazz) {
        this.rawChannel.registerMessage(id, msgClazz, (msg, buf) -> msg.toBytes((FriendlyByteBuf)buf), buf -> {
            try {
                IMessage msg = (IMessage)msgClazz.newInstance();
                msg.fromBytes((FriendlyByteBuf)buf);
                return msg;
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
                return null;
            }
        }, (msg, ctxIn) -> {
            NetworkEvent.Context ctx = (NetworkEvent.Context)ctxIn.get();
            LogicalSide packetOrigin = ctx.getDirection().getOriginationSide();
            ctx.setPacketHandled(true);
            if (msg.getExecutionSide() != null && packetOrigin.equals((Object)msg.getExecutionSide())) {
                MultiPiston.LOGGER.warn("Receving {} at wrong side!", (Object)msg.getClass().getName());
                return;
            }
            ctx.enqueueWork(() -> msg.onExecute(ctx, packetOrigin.equals((Object)LogicalSide.CLIENT)));
        });
    }

    public void sendToPosition(IMessage msg, PacketDistributor.TargetPoint pos) {
        this.rawChannel.send(PacketDistributor.NEAR.with(() -> pos), (Object)msg);
    }

    public void sendToServer(IMessage msg) {
        this.rawChannel.sendToServer((Object)msg);
    }
}

