/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.entities;

import appeng.api.behaviors.ExternalStorageStrategy;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.Setting;
import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.api.inventories.ISegmentedInventory;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.energy.IEnergyService;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.orientation.BlockOrientation;
import appeng.api.orientation.RelativeSide;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import appeng.api.stacks.GenericStack;
import appeng.api.storage.MEStorage;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.api.upgrades.UpgradeInventories;
import appeng.api.util.AECableType;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.blockentity.grid.AENetworkPowerBlockEntity;
import appeng.capabilities.Capabilities;
import appeng.core.definitions.AEItems;
import appeng.helpers.externalstorage.GenericStackFluidStorage;
import appeng.helpers.externalstorage.GenericStackInv;
import appeng.me.storage.CompositeStorage;
import appeng.menu.ISubMenu;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuLocator;
import appeng.menu.locator.MenuLocators;
import appeng.parts.automation.StackWorldBehaviors;
import appeng.util.ConfigManager;
import appeng.util.SettingsFrom;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.CombinedInternalInventory;
import appeng.util.inv.FilteredInternalInventory;
import appeng.util.inv.InternalInventoryHost;
import appeng.util.inv.filter.AEItemFilters;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.pedroksl.advanced_ae.api.IDirectionalOutputHost;
import net.pedroksl.advanced_ae.common.blocks.ReactionChamberBlock;
import net.pedroksl.advanced_ae.common.definitions.AAEBlocks;
import net.pedroksl.advanced_ae.common.definitions.AAEMenus;
import net.pedroksl.advanced_ae.recipes.IngredientStack;
import net.pedroksl.advanced_ae.recipes.ReactionChamberRecipe;
import net.pedroksl.advanced_ae.recipes.ReactionChamberRecipes;
import net.pedroksl.advanced_ae.xmod.Addons;
import net.pedroksl.advanced_ae.xmod.appflux.AppliedFluxPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReactionChamberEntity
extends AENetworkPowerBlockEntity
implements IGridTickable,
IUpgradeableObject,
IConfigurableObject,
IDirectionalOutputHost {
    private static final int MAX_INPUT_SLOTS = 9;
    private static final int MAX_PROCESSING_STEPS = 200;
    private static final int MAX_POWER_STORAGE = 500000;
    private static final int MAX_TANK_CAPACITY = 16000;
    public static final String NBT_ALLOWED_SIDES = "allowedSides";
    private final IUpgradeInventory upgrades;
    private final IConfigManager configManager = new ConfigManager(this::onConfigChanged);
    private final AppEngInternalInventory inputInv = new AppEngInternalInventory((InternalInventoryHost)this, 9, 64);
    private final AppEngInternalInventory outputInv = new AppEngInternalInventory((InternalInventoryHost)this, 1, 64);
    private final InternalInventory inv = new CombinedInternalInventory(new InternalInventory[]{this.inputInv, this.outputInv});
    private final FilteredInternalInventory inputExposed = new FilteredInternalInventory((InternalInventory)this.inputInv, AEItemFilters.INSERT_ONLY);
    private final FilteredInternalInventory outputExposed = new FilteredInternalInventory((InternalInventory)this.outputInv, AEItemFilters.EXTRACT_ONLY);
    private final InternalInventory invExposed = new CombinedInternalInventory(new InternalInventory[]{this.inputExposed, this.outputExposed});
    private final CustomGenericInv fluidInv = new CustomGenericInv(this::onChangeTank, GenericStackInv.Mode.STORAGE, 2);
    private LazyOptional<IFluidHandler> genericCapOp;
    private boolean working = false;
    private int processingTime = 0;
    private boolean dirty = false;
    private ReactionChamberRecipe cachedTask = null;
    private EnumSet<RelativeSide> allowedOutputs = EnumSet.allOf(RelativeSide.class);
    private final HashMap<Direction, Map<AEKeyType, ExternalStorageStrategy>> exportStrategies = new HashMap();
    private boolean showWarning = false;

    public ReactionChamberEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
        this.getMainNode().setIdlePowerUsage(0.0).addService(IGridTickable.class, (IGridNodeService)this);
        this.setInternalMaxPower(500000.0);
        this.fluidInv.setCapacity(AEKeyType.fluids(), 16000L);
        this.upgrades = UpgradeInventories.forMachine(AAEBlocks.REACTION_CHAMBER, (int)4, () -> ((ReactionChamberEntity)this).saveChanges());
        this.configManager.registerSetting(Settings.AUTO_EXPORT, (Enum)YesNo.YES);
        this.setPowerSides(this.getGridConnectableSides(this.getOrientation()));
    }

    public void m_7651_() {
        super.m_7651_();
        if (this.genericCapOp != null) {
            this.genericCapOp.invalidate();
        }
    }

    public boolean isWorking() {
        return this.working;
    }

    public void setWorking(boolean working) {
        if (working != this.working) {
            this.updateBlockState(working);
            this.markForUpdate();
        }
        this.working = working;
    }

    private void updateBlockState(boolean working) {
        BlockState newState;
        if (this.f_58857_ == null || this.notLoaded() || this.m_58901_()) {
            return;
        }
        BlockState current = this.f_58857_.m_8055_(this.f_58858_);
        if (current.m_60734_() instanceof ReactionChamberBlock && current != (newState = (BlockState)current.m_61124_((Property)ReactionChamberBlock.WORKING, (Comparable)Boolean.valueOf(working)))) {
            this.f_58857_.m_7731_(this.f_58858_, newState, 2);
        }
    }

    public int getMaxProcessingTime() {
        return 200;
    }

    public int getProcessingTime() {
        return this.processingTime;
    }

    private void setProcessingTime(int processingTime) {
        this.processingTime = processingTime;
    }

    protected void saveVisualState(CompoundTag data) {
        super.saveVisualState(data);
        data.m_128379_("working", this.isWorking());
    }

    protected void loadVisualState(CompoundTag data) {
        super.loadVisualState(data);
        this.setWorking(data.m_128471_("working"));
    }

    public Set<Direction> getGridConnectableSides(BlockOrientation orientation) {
        return EnumSet.allOf(Direction.class);
    }

    public InternalInventory getInternalInventory() {
        return this.inv;
    }

    public InternalInventory getInput() {
        return this.inputInv;
    }

    public InternalInventory getOutput() {
        return this.outputInv;
    }

    public GenericStackInv getTank() {
        return this.fluidInv;
    }

    public void setShowWarning(boolean show) {
        this.showWarning = show;
    }

    public boolean showWarning() {
        return this.showWarning;
    }

    @Override
    public BlockPos getBlockPosition() {
        return this.m_58899_();
    }

    @Override
    public Level getEntityLevel() {
        return this.m_58904_();
    }

    @Override
    public EnumSet<RelativeSide> getAllowedOutputs() {
        return this.allowedOutputs;
    }

    public FluidStack getFluidStack() {
        AEKey aeKey;
        GenericStack fluid = this.fluidInv.getStack(1);
        FluidStack fluidStack = null;
        if (fluid != null && (aeKey = fluid.what()) instanceof AEFluidKey) {
            AEFluidKey key = (AEFluidKey)aeKey;
            fluidStack = key.toStack((int)fluid.amount());
        }
        return fluidStack;
    }

    @Nullable
    public InternalInventory getSubInventory(ResourceLocation id) {
        if (id.equals((Object)ISegmentedInventory.STORAGE)) {
            return this.getInternalInventory();
        }
        if (id.equals((Object)ISegmentedInventory.UPGRADES)) {
            return this.upgrades;
        }
        return super.getSubInventory(id);
    }

    protected InternalInventory getExposedInventoryForSide(Direction facing) {
        return this.invExposed;
    }

    public IUpgradeInventory getUpgrades() {
        return this.upgrades;
    }

    private void onChangeInventory() {
        this.dirty = true;
        this.getMainNode().ifPresent((grid, node) -> grid.getTickManager().wakeDevice(node));
    }

    public void onChangeInventory(InternalInventory inv, int slot) {
        this.onChangeInventory();
    }

    public void onChangeTank() {
        this.onChangeInventory();
    }

    private boolean hasAutoExportWork() {
        return (!this.outputInv.getStackInSlot(0).m_41619_() || this.fluidInv.getStack(0) != null || this.fluidInv.getAmount(0) > 0L) && this.configManager.getSetting(Settings.AUTO_EXPORT) == YesNo.YES;
    }

    private boolean hasCraftWork() {
        ReactionChamberRecipe task = this.getTask();
        if (task != null) {
            if (task.isItemOutput()) {
                return this.outputInv.insertItem(0, task.getResultItem(), true).m_41619_();
            }
            FluidStack fluid = task.getResultFluid();
            return this.fluidInv.canAdd(0, AEFluidKey.of((FluidStack)fluid), fluid.getAmount());
        }
        this.setProcessingTime(0);
        return this.isWorking();
    }

    @Nullable
    public ReactionChamberRecipe getTask() {
        if (this.cachedTask == null && this.f_58857_ != null) {
            this.cachedTask = this.findRecipe(this.f_58857_);
        }
        return this.cachedTask;
    }

    private ReactionChamberRecipe findRecipe(Level level) {
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        for (int x = 0; x < this.inputInv.size(); ++x) {
            inputs.add(this.inputInv.getStackInSlot(x));
        }
        return ReactionChamberRecipes.findRecipe(level, inputs, this.fluidInv.getStack(1));
    }

    public TickingRequest getTickingRequest(IGridNode iGridNode) {
        return new TickingRequest(1, 20, !this.hasAutoExportWork() && !this.hasCraftWork(), true);
    }

    public TickRateModulation tickingRequest(IGridNode iGridNode, int ticksSinceLastCall) {
        if (this.dirty) {
            ReactionChamberRecipe recipe;
            if (this.f_58857_ != null && (recipe = this.findRecipe(this.f_58857_)) == null) {
                this.setProcessingTime(0);
                this.setWorking(false);
                this.cachedTask = null;
            }
            this.markForUpdate();
            this.dirty = false;
        }
        if (this.hasCraftWork()) {
            this.setWorking(true);
            this.getMainNode().ifPresent(grid -> {
                IEnergyService eg = grid.getEnergyService();
                ReactionChamberEntity src = this;
                int speedFactor = switch (this.upgrades.getInstalledUpgrades((ItemLike)AEItems.SPEED_CARD)) {
                    default -> 2;
                    case 1 -> 3;
                    case 2 -> 5;
                    case 3 -> 10;
                    case 4 -> 50;
                };
                int progressReq = 200 - this.getProcessingTime();
                float powerRatio = progressReq < speedFactor ? (float)progressReq / (float)speedFactor : 1.0f;
                int requiredTicks = Mth.m_14167_((float)(200.0f / (float)speedFactor));
                int powerConsumption = Mth.m_14143_((float)((float)this.getTask().getEnergy() / (float)requiredTicks * powerRatio));
                double powerThreshold = (double)powerConsumption - 0.01;
                LazyOptional capOp = this.getCapability(Capabilities.FORGE_ENERGY, Direction.UP);
                capOp.ifPresent(cap -> {
                    if (Addons.APPFLUX.isLoaded()) {
                        AppliedFluxPlugin.rechargeEnergyStorage(grid, Integer.MAX_VALUE, IActionSource.ofMachine((IActionHost)this), cap);
                    }
                });
                double powerReq = this.extractAEPower(powerConsumption, Actionable.SIMULATE, PowerMultiplier.CONFIG);
                if (powerReq <= powerThreshold) {
                    src = eg;
                    double oldPowerReq = powerReq;
                    if (oldPowerReq > (powerReq = eg.extractAEPower((double)powerConsumption, Actionable.SIMULATE, PowerMultiplier.CONFIG))) {
                        src = this;
                        powerReq = oldPowerReq;
                    }
                }
                if (powerReq > powerThreshold) {
                    src.extractAEPower(powerConsumption, Actionable.MODULATE, PowerMultiplier.CONFIG);
                    this.setProcessingTime(this.getProcessingTime() + speedFactor);
                    this.setShowWarning(false);
                } else if (powerReq != 0.0) {
                    double progressRatio = src == this ? powerReq / (double)powerConsumption : (powerReq - 10.0 * eg.getIdlePowerUsage()) / (double)powerConsumption;
                    int factor = Mth.m_14107_((double)(progressRatio * (double)speedFactor));
                    if (factor > 1) {
                        double extracted = src.extractAEPower((double)(powerConsumption * factor) / (double)speedFactor, Actionable.MODULATE, PowerMultiplier.CONFIG);
                        int actualFactor = (int)Math.floor(extracted / (double)powerConsumption * (double)speedFactor);
                        this.setProcessingTime(this.getProcessingTime() + actualFactor);
                    }
                    this.setShowWarning(true);
                }
            });
            if (this.getProcessingTime() >= this.getMaxProcessingTime()) {
                this.setProcessingTime(0);
                ReactionChamberRecipe out = this.getTask();
                if (out != null) {
                    ItemStack output = out.getResultItem();
                    FluidStack fluidOut = out.getResultFluid();
                    if (out.isItemOutput() && this.outputInv.insertItem(0, output, false).m_41619_() || !out.isItemOutput() && (double)this.fluidInv.add(0, AEFluidKey.of((FluidStack)fluidOut), fluidOut.getAmount()) >= (double)fluidOut.getAmount() - 0.01) {
                        AEKey aeKey;
                        this.setProcessingTime(0);
                        GenericStack fluid = this.fluidInv.getStack(1);
                        FluidStack fluidStack = null;
                        if (fluid != null && (aeKey = fluid.what()) instanceof AEFluidKey) {
                            AEFluidKey key = (AEFluidKey)aeKey;
                            fluidStack = key.toStack((int)fluid.amount());
                        }
                        for (IngredientStack<?, ?> input : out.getValidInputs()) {
                            for (int x = 0; x < this.inputInv.size(); ++x) {
                                ItemStack stack = this.inputInv.getStackInSlot(x);
                                if (input.checkType(stack)) {
                                    ((IngredientStack.Item)input).consume(stack);
                                    this.inputInv.setItemDirect(x, stack);
                                }
                                if (input.isEmpty()) break;
                            }
                            if (fluidStack == null || input.isEmpty() || !input.checkType(fluidStack)) continue;
                            ((IngredientStack.Fluid)input).consume(fluidStack);
                        }
                        if (fluidStack != null) {
                            if (fluidStack.isEmpty()) {
                                this.fluidInv.setStack(1, null);
                            } else {
                                this.fluidInv.setStack(1, new GenericStack((AEKey)Objects.requireNonNull(AEFluidKey.of((FluidStack)fluidStack)), (long)fluidStack.getAmount()));
                            }
                        }
                    }
                }
                this.saveChanges();
                this.cachedTask = null;
                this.setWorking(false);
            }
        } else {
            this.setShowWarning(false);
        }
        if (this.pushOutResult()) {
            return TickRateModulation.URGENT;
        }
        return this.hasCraftWork() ? TickRateModulation.URGENT : (this.hasAutoExportWork() ? TickRateModulation.SLOWER : TickRateModulation.SLEEP);
    }

    private boolean pushOutResult() {
        if (!this.hasAutoExportWork()) {
            return false;
        }
        BlockOrientation orientation = this.getOrientation();
        for (RelativeSide side : this.allowedOutputs) {
            GenericStack outFluid;
            Direction dir = orientation.getSide(side);
            CompositeStorage target = this.getTarget(dir);
            if (target == null) continue;
            IActionSource source = IActionSource.ofMachine((IActionHost)this);
            boolean movedStacks = false;
            GenericStack genStack = GenericStack.fromItemStack((ItemStack)this.outputInv.getStackInSlot(0));
            if (genStack != null && genStack.what() != null) {
                ItemStack extractedStack = this.outputInv.extractItem(0, 64, false);
                long inserted = target.insert(genStack.what(), (long)extractedStack.m_41613_(), Actionable.MODULATE, source);
                extractedStack.m_41764_(extractedStack.m_41613_() - (int)inserted);
                this.outputInv.insertItem(0, extractedStack, false);
                movedStacks |= inserted > 0L;
            }
            if ((outFluid = this.fluidInv.getStack(0)) != null && outFluid.what() != null) {
                long extracted = this.fluidInv.extract(0, outFluid.what(), outFluid.amount(), Actionable.MODULATE);
                long inserted = target.insert(outFluid.what(), extracted, Actionable.MODULATE, source);
                this.fluidInv.add(0, (AEFluidKey)outFluid.what(), (int)(extracted - inserted));
                if (this.fluidInv.getAmount(0) == 0L) {
                    this.clearFluidOut();
                }
                movedStacks |= inserted > 0L;
            }
            if (!movedStacks) continue;
            return true;
        }
        return false;
    }

    private CompositeStorage getTarget(Direction dir) {
        if (this.exportStrategies.get(dir) == null) {
            BlockEntity be = this.getBlockEntity();
            this.exportStrategies.put(dir, StackWorldBehaviors.createExternalStorageStrategies((ServerLevel)((ServerLevel)be.m_58904_()), (BlockPos)be.m_58899_().m_121945_(dir), (Direction)dir.m_122424_()));
        }
        IdentityHashMap<AEKeyType, MEStorage> externalStorages = new IdentityHashMap<AEKeyType, MEStorage>(2);
        for (Map.Entry<AEKeyType, ExternalStorageStrategy> entry : this.exportStrategies.get(dir).entrySet()) {
            MEStorage wrapper = entry.getValue().createWrapper(false, () -> {});
            if (wrapper == null) continue;
            externalStorages.put(entry.getKey(), wrapper);
        }
        if (!externalStorages.isEmpty()) {
            return new CompositeStorage(externalStorages);
        }
        return null;
    }

    public IConfigManager getConfigManager() {
        return this.configManager;
    }

    public AECableType getCableConnectionType(Direction dir) {
        return AECableType.COVERED;
    }

    public void m_183515_(CompoundTag data) {
        super.m_183515_(data);
        this.fluidInv.writeToChildTag(data, "tank");
        ListTag outputTags = new ListTag();
        for (RelativeSide side : this.allowedOutputs) {
            outputTags.add((Object)StringTag.m_129297_((String)side.name()));
        }
        data.m_128365_("outputs", (Tag)outputTags);
        this.upgrades.writeToNBT(data, "upgrades");
        this.configManager.writeToNBT(data);
    }

    public void loadTag(CompoundTag data) {
        super.loadTag(data);
        this.fluidInv.readFromChildTag(data, "tank");
        this.allowedOutputs.clear();
        ListTag outputTags = data.m_128437_("outputs", 8);
        if (!outputTags.isEmpty()) {
            for (int x = 0; x < outputTags.size(); ++x) {
                RelativeSide side = Enum.valueOf(RelativeSide.class, outputTags.m_128778_(x));
                this.allowedOutputs.add(side);
            }
        }
        this.upgrades.readFromNBT(data, "upgrades");
        this.configManager.readFromNBT(data);
    }

    protected boolean readFromStream(FriendlyByteBuf data) {
        boolean newWorking;
        boolean c = super.readFromStream(data);
        boolean oldWorking = this.isWorking();
        if (oldWorking != (newWorking = data.readBoolean()) && newWorking) {
            this.setWorking(true);
        }
        for (int i = 0; i < this.inv.size(); ++i) {
            this.inv.setItemDirect(i, data.m_130267_());
        }
        this.fluidInv.setStack(0, GenericStack.readBuffer((FriendlyByteBuf)data));
        this.fluidInv.setStack(1, GenericStack.readBuffer((FriendlyByteBuf)data));
        this.cachedTask = null;
        return c;
    }

    protected void writeToStream(FriendlyByteBuf data) {
        super.writeToStream(data);
        data.writeBoolean(this.isWorking());
        for (int i = 0; i < this.inv.size(); ++i) {
            data.m_130055_(this.inv.getStackInSlot(i));
        }
        GenericStack.writeBuffer((GenericStack)this.fluidInv.getStack(0), (FriendlyByteBuf)data);
        GenericStack.writeBuffer((GenericStack)this.fluidInv.getStack(1), (FriendlyByteBuf)data);
    }

    public void exportSettings(SettingsFrom mode, CompoundTag output, @Nullable Player player) {
        super.exportSettings(mode, output, player);
        if (mode == SettingsFrom.MEMORY_CARD) {
            EnumSet<RelativeSide> outputs = this.getAllowedOutputs();
            IntArrayTag sides = new IntArrayTag(outputs.stream().map(o -> o.getUnrotatedSide().m_122411_()).toList());
            output.m_128365_(NBT_ALLOWED_SIDES, (Tag)sides);
        }
    }

    public void importSettings(SettingsFrom mode, CompoundTag input, @Nullable Player player) {
        Tag tag;
        super.importSettings(mode, input, player);
        if (mode == SettingsFrom.MEMORY_CARD && (tag = input.m_128423_(NBT_ALLOWED_SIDES)) instanceof IntArrayTag) {
            BlockEntity be;
            IntArrayTag list = (IntArrayTag)tag;
            Level level = this.m_58904_();
            if (level != null && (be = level.m_7702_(this.m_58899_())) instanceof IDirectionalOutputHost) {
                IDirectionalOutputHost host = (IDirectionalOutputHost)be;
                EnumSet<RelativeSide> outputs = EnumSet.noneOf(RelativeSide.class);
                for (IntTag item : list) {
                    outputs.add(RelativeSide.fromUnrotatedSide((Direction)Direction.m_122376_((int)item.m_7047_())));
                }
                host.updateOutputSides(outputs);
            }
        }
    }

    private void onConfigChanged(IConfigManager manager, Setting<?> setting) {
        if (setting == Settings.AUTO_EXPORT) {
            this.getMainNode().ifPresent((grid, node) -> grid.getTickManager().wakeDevice(node));
        }
        this.saveChanges();
    }

    public void addAdditionalDrops(Level level, BlockPos pos, List<ItemStack> drops) {
        super.addAdditionalDrops(level, pos, drops);
        for (ItemStack upgrade : this.upgrades) {
            drops.add(upgrade);
        }
        for (int i = 0; i < this.fluidInv.size(); ++i) {
            GenericStack fluid = this.fluidInv.getStack(i);
            if (fluid == null) continue;
            fluid.what().addDrops(fluid.amount(), drops, level, pos);
        }
    }

    public void m_6211_() {
        super.m_6211_();
        this.fluidInv.clear();
        this.upgrades.clear();
    }

    public void clearFluid() {
        this.fluidInv.clear(1);
    }

    public void clearFluidOut() {
        this.fluidInv.clear(0);
    }

    @Override
    public void updateOutputSides(EnumSet<RelativeSide> allowedOutputs) {
        this.allowedOutputs = allowedOutputs;
        this.saveChanges();
    }

    public void returnToMainMenu(Player player, ISubMenu iSubMenu) {
        MenuOpener.returnTo(AAEMenus.REACTION_CHAMBER.get(), (Player)player, (MenuLocator)MenuLocators.forBlockEntity((BlockEntity)this));
    }

    public ItemStack getMainMenuIcon() {
        return new ItemStack((ItemLike)AAEBlocks.REACTION_CHAMBER.asItem());
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == Capabilities.GENERIC_INTERNAL_INV) {
            LazyOptional cap = LazyOptional.of(this::getTank).cast();
            if (cap.isPresent()) {
                return cap;
            }
        } else if (capability == ForgeCapabilities.FLUID_HANDLER) {
            if (this.genericCapOp == null) {
                this.genericCapOp = LazyOptional.of(this::getTank).lazyMap(GenericStackFluidStorage::new).cast();
            }
            return this.genericCapOp.cast();
        }
        return super.getCapability(capability, facing);
    }

    private static class CustomGenericInv
    extends GenericStackInv {
        public CustomGenericInv(@Nullable Runnable listener, GenericStackInv.Mode mode, int size) {
            super(listener, mode, size);
        }

        public boolean isAllowed(AEKey what) {
            if (!(what instanceof AEFluidKey)) {
                return false;
            }
            return super.isAllowed(what);
        }

        public long insert(int slot, AEKey what, long amount, Actionable mode) {
            if (slot == 0) {
                return 0L;
            }
            return super.insert(slot, what, amount, mode);
        }

        public long extract(int slot, AEKey what, long amount, Actionable mode) {
            if (slot == 1) {
                return 0L;
            }
            return super.extract(slot, what, amount, mode);
        }

        public boolean canAdd(int slot, AEFluidKey key, int amount) {
            GenericStack stack = this.getStack(slot);
            if (stack == null) {
                return true;
            }
            if (!stack.what().equals(key)) {
                return false;
            }
            return stack.amount() + (long)amount <= this.getMaxAmount((AEKey)key);
        }

        public int add(int slot, AEFluidKey key, int amount) {
            if (!this.canAdd(slot, key, amount)) {
                return 0;
            }
            GenericStack stack = this.getStack(slot);
            int newAmount = amount;
            if (stack != null) {
                newAmount += (int)stack.amount();
            }
            assert (stack != null);
            this.setStack(slot, new GenericStack((AEKey)key, (long)newAmount));
            return amount;
        }

        public void clear(int slot) {
            boolean changed = this.stacks[slot] != null;
            this.setStack(slot, null);
            if (changed) {
                this.onChange();
            }
        }
    }
}

