/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.blocks;

import appeng.block.AEBaseEntityBlock;
import appeng.block.crafting.PushDirection;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuLocator;
import appeng.menu.locator.MenuLocators;
import appeng.util.InteractionUtil;
import appeng.util.Platform;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.pedroksl.advanced_ae.common.definitions.AAEMenus;
import net.pedroksl.advanced_ae.common.entities.AdvPatternProviderEntity;
import org.jetbrains.annotations.Nullable;

public class AdvPatternProviderBlock
extends AEBaseEntityBlock<AdvPatternProviderEntity> {
    public static final EnumProperty<PushDirection> PUSH_DIRECTION = EnumProperty.m_61587_((String)"push_direction", PushDirection.class);
    public static final BooleanProperty CONNECTION_STATE = BooleanProperty.m_61465_((String)"connection_state");

    public AdvPatternProviderBlock() {
        super(AdvPatternProviderBlock.metalProps());
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_(PUSH_DIRECTION, (Comparable)PushDirection.ALL)).m_61124_((Property)CONNECTION_STATE, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{PUSH_DIRECTION});
        builder.m_61104_(new Property[]{CONNECTION_STATE});
    }

    @ParametersAreNonnullByDefault
    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        AdvPatternProviderEntity be = (AdvPatternProviderEntity)this.getBlockEntity((BlockGetter)level, pos);
        if (be != null) {
            be.getLogic().updateRedstoneState();
        }
    }

    public InteractionResult onActivated(Level level, BlockPos pos, Player p, InteractionHand hand, @Nullable ItemStack heldItem, BlockHitResult hit) {
        if (InteractionUtil.isInAlternateUseMode((Player)p)) {
            return InteractionResult.PASS;
        }
        if (heldItem != null && InteractionUtil.canWrenchRotate((ItemStack)heldItem)) {
            this.setSide(level, pos, hit.m_82434_());
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        AdvPatternProviderEntity be = (AdvPatternProviderEntity)this.getBlockEntity((BlockGetter)level, pos);
        if (be != null) {
            if (!level.m_5776_()) {
                MenuOpener.open(AAEMenus.ADV_PATTERN_PROVIDER.get(), (Player)p, (MenuLocator)MenuLocators.forBlockEntity((BlockEntity)be));
            }
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        return InteractionResult.PASS;
    }

    public void setSide(Level level, BlockPos pos, Direction facing) {
        BlockState currentState = level.m_8055_(pos);
        Direction pushSide = ((PushDirection)currentState.m_61143_(PUSH_DIRECTION)).getDirection();
        PushDirection newPushDirection = pushSide == facing.m_122424_() ? PushDirection.fromDirection((Direction)facing) : (pushSide == facing ? PushDirection.ALL : (pushSide == null ? PushDirection.fromDirection((Direction)facing.m_122424_()) : PushDirection.fromDirection((Direction)Platform.rotateAround((Direction)pushSide, (Direction)facing))));
        level.m_46597_(pos, (BlockState)currentState.m_61124_(PUSH_DIRECTION, (Comparable)newPushDirection));
    }
}

