/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.client.fakelevel;

import com.ldtteam.structurize.client.fakelevel.FakeChunk;
import com.ldtteam.structurize.client.fakelevel.FakeChunkSource;
import com.ldtteam.structurize.client.fakelevel.FakeLevelData;
import com.ldtteam.structurize.client.fakelevel.FakeLevelEntityGetterAdapter;
import com.ldtteam.structurize.client.fakelevel.FakeLevelLightEngine;
import com.ldtteam.structurize.client.fakelevel.IFakeLevelBlockGetter;
import com.ldtteam.structurize.client.fakelevel.IFakeLevelLightProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.AbortableIterationConsumer;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.level.storage.WritableLevelData;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.ticks.BlackholeTickAccess;
import net.minecraft.world.ticks.LevelTickAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FakeLevel
extends Level {
    protected IFakeLevelBlockGetter levelSource;
    protected final IFakeLevelLightProvider lightProvider;
    protected Level realLevel;
    protected final Scoreboard scoreboard;
    protected final boolean overrideBeLevel;
    protected final FakeChunkSource chunkSource;
    protected final FakeLevelLightEngine lightEngine;
    protected FakeLevelEntityGetterAdapter levelEntityGetter = FakeLevelEntityGetterAdapter.EMPTY;
    protected Map<BlockPos, BlockEntity> blockEntities = Collections.emptyMap();
    protected BlockPos worldPos = BlockPos.f_121853_;
    int lastX;
    int lastZ;
    ChunkAccess lastChunk = null;

    public FakeLevel(IFakeLevelBlockGetter levelSource, IFakeLevelLightProvider lightProvider, @Nullable Scoreboard scoreboard, boolean overrideBeLevel) {
        super((WritableLevelData)new FakeLevelData(() -> ((ClientLevel)FakeLevel.clientLevel()).m_6106_(), lightProvider), FakeLevel.clientLevel().m_46472_(), FakeLevel.clientLevel().m_9598_(), FakeLevel.clientLevel().m_204156_(), FakeLevel.clientLevel().m_46658_(), FakeLevel.clientLevel().m_5776_(), false, 0L, 0);
        this.levelSource = levelSource;
        this.lightProvider = lightProvider;
        this.realLevel = FakeLevel.clientLevel();
        this.scoreboard = scoreboard;
        this.overrideBeLevel = overrideBeLevel;
        this.chunkSource = new FakeChunkSource(this);
        this.lightEngine = new FakeLevelLightEngine(this);
        this.setRealLevel((Level)FakeLevel.clientLevel());
        ((FakeLevelData)this.m_6106_()).vanillaLevelData = () -> this.realLevel().m_6106_();
    }

    protected static ClientLevel clientLevel() {
        return Minecraft.m_91087_().f_91073_;
    }

    public void setRealLevel(Level realLevel) {
        if (Objects.equals(this.realLevel, realLevel)) {
            return;
        }
        if (realLevel != null && realLevel.f_46443_ != this.f_46443_) {
            throw new IllegalArgumentException("Received wrong sided realLevel - fakeLevel.isClientSide = " + this.f_46443_);
        }
        this.realLevel = realLevel;
    }

    public Level realLevel() {
        return this.realLevel;
    }

    public void setLevelSource(IFakeLevelBlockGetter levelSource) {
        this.levelSource = levelSource;
    }

    public IFakeLevelBlockGetter getLevelSource() {
        return this.levelSource;
    }

    public void setWorldPos(BlockPos worldPos) {
        this.worldPos = worldPos;
    }

    public BlockPos getWorldPos() {
        return this.worldPos;
    }

    public void setBlockEntities(Map<BlockPos, BlockEntity> blockEntities) {
        this.blockEntities = blockEntities;
    }

    public void setEntities(Collection<? extends Entity> entities) {
        this.levelEntityGetter = entities.isEmpty() ? FakeLevelEntityGetterAdapter.EMPTY : FakeLevelEntityGetterAdapter.ofEntities(entities);
    }

    public ResourceKey<Level> m_46472_() {
        return this.realLevel() != null ? this.realLevel().m_46472_() : super.m_46472_();
    }

    public RegistryAccess m_9598_() {
        return this.realLevel() != null ? this.realLevel().m_9598_() : super.m_9598_();
    }

    public DamageSources m_269111_() {
        return this.realLevel() != null ? this.realLevel().m_269111_() : super.m_269111_();
    }

    public ProfilerFiller m_46473_() {
        return this.realLevel() != null ? this.realLevel().m_46473_() : super.m_46473_();
    }

    public Supplier<ProfilerFiller> m_46658_() {
        return this.realLevel() != null ? this.realLevel().m_46658_() : super.m_46658_();
    }

    public DimensionType m_6042_() {
        return this.realLevel() != null ? this.realLevel().m_6042_() : super.m_6042_();
    }

    public Holder<DimensionType> m_204156_() {
        return this.realLevel() != null ? this.realLevel().m_204156_() : super.m_204156_();
    }

    public WorldBorder m_6857_() {
        return this.realLevel() != null ? this.realLevel().m_6857_() : super.m_6857_();
    }

    @Nullable
    public BlockEntity m_7702_(BlockPos pos) {
        BlockEntity blockEntity;
        BlockEntity blockEntity2 = blockEntity = this.blockEntities.isEmpty() ? this.levelSource.m_7702_(pos) : this.blockEntities.get(pos);
        if (blockEntity != null && blockEntity.m_58904_() != this && (this.overrideBeLevel || !blockEntity.m_58898_())) {
            blockEntity.m_142339_((Level)this);
        }
        return blockEntity;
    }

    @Nullable
    public BlockEntity getExistingBlockEntity(BlockPos pos) {
        return this.m_7702_(pos);
    }

    public BlockState m_8055_(BlockPos pos) {
        return this.levelSource.isPosInside(pos) ? this.levelSource.m_8055_(pos) : Blocks.f_50016_.m_49966_();
    }

    public ChunkAccess m_6522_(int x, int z, ChunkStatus requiredStatus, boolean nonnull) {
        if (this.lastX == x && this.lastZ == z && this.lastChunk != null) {
            return this.lastChunk;
        }
        return nonnull || this.m_7232_(x, z) ? new FakeChunk(this, x, z) : null;
    }

    public boolean m_7232_(int chunkX, int chunkZ) {
        int posX = SectionPos.m_123223_((int)chunkX);
        int posZ = SectionPos.m_123223_((int)chunkZ);
        return this.levelSource.getMinX() <= posX && posX < this.levelSource.getMaxX() && this.levelSource.getMinZ() <= posZ && posZ < this.levelSource.getMaxZ();
    }

    public int m_45517_(LightLayer lightType, BlockPos pos) {
        return this.lightProvider.forceOwnLightLevel() ? this.lightProvider.getBrightness(lightType, pos) : this.realLevel().m_45517_(lightType, this.worldPos.m_121955_((Vec3i)pos));
    }

    public int m_45524_(BlockPos pos, int amount) {
        return this.lightProvider.forceOwnLightLevel() ? this.lightProvider.getRawBrightness(pos, amount) : this.realLevel().m_45524_(this.worldPos.m_121955_((Vec3i)pos), amount);
    }

    public int m_7445_() {
        return this.lightProvider.forceOwnLightLevel() ? this.lightProvider.getSkyDarken() : this.realLevel().m_7445_();
    }

    public boolean m_46461_() {
        return !this.m_6042_().m_63967_() && this.m_7445_() < 4;
    }

    public Scoreboard m_6188_() {
        return this.scoreboard == null ? this.realLevel().m_6188_() : this.scoreboard;
    }

    public FluidState m_6425_(BlockPos pos) {
        return this.levelSource.m_6425_(pos);
    }

    public int m_141928_() {
        return this.levelSource.m_141928_();
    }

    public int m_141937_() {
        return this.levelSource.m_141937_();
    }

    public boolean m_46739_(BlockPos pos) {
        return this.levelSource.isPosInside(pos);
    }

    public CrashReportCategory m_6026_(CrashReport report) {
        CrashReportCategory crashreportcategory = report.m_127514_("Structurize fake level");
        this.levelSource.describeSelfInCrashReport(crashreportcategory);
        return crashreportcategory;
    }

    protected LevelEntityGetter<Entity> m_142646_() {
        return this.levelEntityGetter;
    }

    @javax.annotation.Nullable
    public Entity m_6815_(int id) {
        return (Entity)this.levelEntityGetter.m_142597_(id);
    }

    public List<AbstractClientPlayer> m_6907_() {
        ArrayList<AbstractClientPlayer> result = new ArrayList<AbstractClientPlayer>();
        this.levelEntityGetter.m_142690_(EntityTypeTest.m_156916_(AbstractClientPlayer.class), player -> {
            result.add((AbstractClientPlayer)player);
            return AbortableIterationConsumer.Continuation.CONTINUE;
        });
        return result;
    }

    public int m_6924_(Heightmap.Types heightmapType, int x, int z) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(x, this.levelSource.m_141937_(), z);
        if (this.levelSource.isPosInside((BlockPos)pos)) {
            for (int y = this.levelSource.m_151558_() - 1; y >= this.levelSource.m_141937_(); --y) {
                pos.m_142448_(y);
                if (!heightmapType.m_64299_().test(this.levelSource.m_8055_((BlockPos)pos))) continue;
                return y;
            }
        }
        return this.levelSource.m_141937_();
    }

    public ChunkSource m_7726_() {
        return this.chunkSource;
    }

    public LevelLightEngine m_5518_() {
        return this.lightEngine;
    }

    public String m_46464_() {
        return "Fake level for: " + this.levelSource;
    }

    public float m_7717_(Direction p_104703_, boolean p_104704_) {
        return this.realLevel().m_7717_(p_104703_, p_104704_);
    }

    public Holder<Biome> m_204166_(BlockPos pos) {
        return this.realLevel().m_204166_(this.worldPos.m_121955_((Vec3i)pos));
    }

    public BiomeManager m_7062_() {
        return this.realLevel().m_7062_();
    }

    public RecipeManager m_7465_() {
        return this.realLevel().m_7465_();
    }

    public FeatureFlagSet m_246046_() {
        return this.realLevel().m_246046_();
    }

    public Holder<Biome> m_203675_(int x, int y, int z) {
        return this.realLevel().m_203675_(x, y, z);
    }

    public Holder<Biome> m_203495_(int x, int y, int z) {
        return this.realLevel().m_203495_(x, y, z);
    }

    public Explosion m_255278_(@javax.annotation.Nullable Entity p_256233_, @javax.annotation.Nullable DamageSource p_255861_, @javax.annotation.Nullable ExplosionDamageCalculator p_255867_, double p_256447_, double p_255732_, double p_255717_, float p_256013_, boolean p_256228_, Level.ExplosionInteraction p_255784_, boolean p_256377_) {
        throw new UnsupportedOperationException("Structurize fake immutable level - no explosions possible!");
    }

    public boolean m_46749_(BlockPos pos) {
        return true;
    }

    public float m_46722_(float delta) {
        return 0.0f;
    }

    public float m_46661_(float delta) {
        return 0.0f;
    }

    public boolean m_46758_(BlockPos position) {
        return this.m_46471_();
    }

    public boolean m_7441_() {
        return true;
    }

    public int m_5736_() {
        return 0;
    }

    public void m_6801_(int p_46506_, BlockPos p_46507_, int p_46508_) {
    }

    public int m_7354_() {
        return 0;
    }

    @javax.annotation.Nullable
    public MapItemSavedData m_7489_(String p_46650_) {
        return null;
    }

    public void m_213890_(@javax.annotation.Nullable Player p_220372_, Entity p_220373_, Holder<SoundEvent> p_263500_, SoundSource p_220375_, float p_220376_, float p_220377_, long p_220378_) {
    }

    public void m_262808_(@javax.annotation.Nullable Player p_262953_, double p_263004_, double p_263398_, double p_263376_, Holder<SoundEvent> p_263359_, SoundSource p_263020_, float p_263055_, float p_262914_, long p_262991_) {
    }

    public void m_7260_(BlockPos p_46612_, BlockState p_46613_, BlockState p_46614_, int p_46615_) {
    }

    public void m_142325_(String p_151533_, MapItemSavedData p_151534_) {
    }

    public void m_214171_(GameEvent p_220404_, Vec3 p_220405_, GameEvent.Context p_220406_) {
    }

    public LevelTickAccess<Block> m_183326_() {
        return BlackholeTickAccess.m_193145_();
    }

    public LevelTickAccess<Fluid> m_183324_() {
        return BlackholeTickAccess.m_193145_();
    }

    public void m_5898_(@javax.annotation.Nullable Player p_46771_, int p_46772_, BlockPos p_46773_, int p_46774_) {
    }

    public void m_151525_(TickingBlockEntity p_151526_) {
    }

    public void addFreshBlockEntities(Collection<BlockEntity> beList) {
    }

    public void m_7696_(BlockPos p_46582_, Block p_46583_, int p_46584_, int p_46585_) {
    }

    public void close() throws IOException {
    }

    public boolean m_7740_(BlockPos p_46626_, boolean p_46627_, @javax.annotation.Nullable Entity p_46628_, int p_46629_) {
        return false;
    }

    public void markAndNotifyBlock(BlockPos p_46605_, @javax.annotation.Nullable LevelChunk levelchunk, BlockState blockstate, BlockState p_46606_, int p_46607_, int p_46608_) {
    }

    public boolean m_7966_(Player p_46557_, BlockPos p_46558_) {
        return false;
    }

    public void m_213683_(Direction p_220385_, BlockState p_220386_, BlockPos p_220387_, BlockPos p_220388_, int p_220389_, int p_220390_) {
    }

    public boolean m_7471_(BlockPos p_46623_, boolean p_46624_) {
        return false;
    }

    public boolean m_6933_(BlockPos p_46605_, BlockState p_46606_, int p_46607_, int p_46608_) {
        return false;
    }

    public void m_46734_(float p_46735_) {
    }

    public void m_46703_(boolean p_46704_, boolean p_46705_) {
    }

    public void m_46707_(float p_46708_) {
    }

    public boolean m_183438_(long p_186456_) {
        return false;
    }

    public boolean m_183599_(Entity p_186458_) {
        return false;
    }

    protected void m_46463_() {
    }

    public void m_46672_(BlockPos p_46673_, Block p_46674_) {
    }

    public void m_46465_() {
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return LazyOptional.empty();
    }

    public void invalidateCaps() {
    }

    public void reviveCaps() {
    }
}

