/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.ponderjs.api;

import com.almostreliable.ponderjs.api.CustomPonderOverlayElement;
import com.almostreliable.ponderjs.api.CustomPonderSceneElement;
import com.almostreliable.ponderjs.mixin.SceneBuilderAccessor;
import com.almostreliable.ponderjs.particles.ParticleInstructions;
import com.almostreliable.ponderjs.util.BlockStateFunction;
import com.almostreliable.ponderjs.util.PonderPlatform;
import com.google.common.base.Preconditions;
import com.simibubi.create.foundation.ponder.ElementLink;
import com.simibubi.create.foundation.ponder.PonderPalette;
import com.simibubi.create.foundation.ponder.PonderScene;
import com.simibubi.create.foundation.ponder.PonderWorld;
import com.simibubi.create.foundation.ponder.SceneBuilder;
import com.simibubi.create.foundation.ponder.Selection;
import com.simibubi.create.foundation.ponder.element.EntityElement;
import com.simibubi.create.foundation.ponder.element.InputWindowElement;
import com.simibubi.create.foundation.ponder.element.PonderElement;
import com.simibubi.create.foundation.ponder.element.TextWindowElement;
import com.simibubi.create.foundation.ponder.instruction.FadeInOutInstruction;
import com.simibubi.create.foundation.ponder.instruction.PonderInstruction;
import com.simibubi.create.foundation.ponder.instruction.ShowInputInstruction;
import com.simibubi.create.foundation.ponder.instruction.TickingInstruction;
import com.simibubi.create.foundation.utility.Pointing;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class ExtendedSceneBuilder
extends SceneBuilder {
    private final ParticleInstructions particles;
    private final PonderScene ponderScene;

    public ExtendedSceneBuilder(PonderScene ponderScene) {
        super(ponderScene);
        this.ponderScene = ponderScene;
        ((SceneBuilderAccessor)((Object)this)).ponderjs$setWorldInstructions(new ExtendedWorldInstructions());
        ((SceneBuilderAccessor)((Object)this)).ponderjs$setSpecialInstructions(new ExtendedSpecialInstructions());
        ((SceneBuilderAccessor)((Object)this)).ponderjs$setOverlayInstructions(new ExtendedOverlayInstructions());
        this.particles = new ParticleInstructions(this);
    }

    public ExtendedWorldInstructions getWorld() {
        return (ExtendedWorldInstructions)this.world;
    }

    public ExtendedWorldInstructions getLevel() {
        return (ExtendedWorldInstructions)this.world;
    }

    public SceneBuilder.DebugInstructions getDebug() {
        return this.debug;
    }

    public SceneBuilder.OverlayInstructions getOverlay() {
        return this.overlay;
    }

    public SceneBuilder.EffectInstructions getEffects() {
        return this.effects;
    }

    public SceneBuilder.SpecialInstructions getSpecial() {
        return this.special;
    }

    public ParticleInstructions getParticles() {
        return this.particles;
    }

    public void showStructure() {
        this.showStructure(this.ponderScene.getBasePlateSize() * 2);
    }

    public void showStructure(int height) {
        BlockPos start = new BlockPos(this.ponderScene.getBasePlateOffsetX(), 0, this.ponderScene.getBasePlateOffsetZ());
        BlockPos size = new BlockPos(this.ponderScene.getBasePlateSize() - 1, height, this.ponderScene.getBasePlateSize() - 1);
        Selection selection = this.ponderScene.getSceneBuildingUtil().select.cuboid(start, (Vec3i)size);
        this.encapsulateBounds(size);
        this.world.showSection(selection, Direction.UP);
    }

    public void encapsulateBounds(BlockPos size) {
        this.addInstruction(ps -> {
            PonderWorld w = ps.getWorld();
            if (w != null) {
                w.getBounds().m_162371_(size);
            }
        });
    }

    public void playSound(SoundEvent soundEvent, SoundSource soundSource, float volume, float pitch) {
        Preconditions.checkArgument((soundEvent != null ? 1 : 0) != 0, (Object)"Given sound does not exist");
        if (Minecraft.m_91087_().f_91074_ != null) {
            this.addInstruction(ps -> {
                SimpleSoundInstance sound = new SimpleSoundInstance(soundEvent, soundSource, volume, pitch, SoundInstance.m_235150_(), Minecraft.m_91087_().f_91074_.m_20183_());
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)sound);
            });
        }
    }

    public void playSound(SoundEvent soundEvent, float volume) {
        this.playSound(soundEvent, SoundSource.MASTER, volume, 1.0f);
    }

    public void playSound(SoundEvent soundEvent) {
        this.playSound(soundEvent, SoundSource.MASTER, 1.0f, 1.0f);
    }

    public TextWindowElement.Builder text(int duration, String text) {
        return this.overlay.showText(duration).text(text);
    }

    public TextWindowElement.Builder text(int duration, String text, Vec3 position) {
        return this.overlay.showText(duration).text(text).pointAt(position);
    }

    public TextWindowElement.Builder sharedText(int duration, ResourceLocation key) {
        return this.overlay.showText(duration).sharedText(key);
    }

    public TextWindowElement.Builder sharedText(int duration, ResourceLocation key, Vec3 position) {
        return this.overlay.showText(duration).sharedText(key).pointAt(position).colored(PonderPalette.BLUE);
    }

    public InputWindowElement showControls(int duration, Vec3 pos, Pointing pointing) {
        InputWindowElement element = new InputWindowElement(pos, pointing);
        this.addInstruction((PonderInstruction)new ShowInputInstruction(element, duration));
        return element;
    }

    public class ExtendedWorldInstructions
    extends SceneBuilder.WorldInstructions {
        public ExtendedWorldInstructions() {
            super((SceneBuilder)ExtendedSceneBuilder.this);
        }

        public CustomPonderSceneElement addElement(int ticks) {
            final CustomPonderSceneElement element = new CustomPonderSceneElement();
            element.setVisible(false);
            ExtendedSceneBuilder.this.addInstruction((PonderInstruction)new FadeInOutInstruction(ticks){

                protected void show(PonderScene scene) {
                    scene.addElement((PonderElement)element);
                    element.setVisible(true);
                }

                protected void hide(PonderScene scene) {
                    element.setVisible(false);
                }

                protected void applyFade(PonderScene scene, float fade) {
                    element.setFade(fade);
                }
            });
            return element;
        }

        public CustomPonderSceneElement addElement() {
            CustomPonderSceneElement element = new CustomPonderSceneElement();
            ExtendedSceneBuilder.this.addInstruction(ponderScene -> {
                ponderScene.addElement((PonderElement)element);
                element.setVisible(true);
            });
            return element;
        }

        public ElementLink<EntityElement> createEntity(EntityType<?> entityType, Vec3 position, Consumer<Entity> consumer) {
            return this.createEntity(level -> {
                Entity entity = entityType.m_20615_(level);
                Objects.requireNonNull(entity, "Could not create entity of type " + PonderPlatform.getEntityTypeName(entityType));
                entity.m_20343_(position.f_82479_, position.f_82480_, position.f_82481_);
                entity.m_146867_();
                entity.m_7618_(EntityAnchorArgument.Anchor.FEET, position.m_82520_(0.0, 0.0, -1.0));
                consumer.accept(entity);
                return entity;
            });
        }

        public ElementLink<EntityElement> createEntity(EntityType<?> entityType, Vec3 position) {
            return this.createEntity(entityType, position, entity -> {});
        }

        public void modifyBlocks(Selection pos, BlockStateFunction function) {
            this.modifyBlocks(pos, true, function);
        }

        public void modifyBlocks(Selection selection, boolean spawnParticles, BlockStateFunction function) {
            this.modifyBlocks(selection, BlockStateFunction.from(function), spawnParticles);
        }

        public void modifyBlocks(Selection selection, BlockStateFunction function, boolean spawnParticles) {
            this.modifyBlocks(selection, BlockStateFunction.from(function), spawnParticles);
        }

        public void modifyBlock(BlockPos pos, BlockStateFunction function, boolean spawnParticles) {
            this.modifyBlock(pos, BlockStateFunction.from(function), spawnParticles);
        }

        public void setBlocks(Selection selection, BlockState blockState) {
            this.setBlocks(selection, true, blockState);
        }

        public void setBlocks(Selection selection, boolean spawnParticles, BlockState blockState) {
            this.setBlocks(selection, blockState, spawnParticles);
        }

        @Deprecated(forRemoval=true)
        public void modifyTileNBT(Selection selection, Consumer<CompoundTag> consumer) {
            ConsoleJS.CLIENT.warn((Object)"[PonderJS] modifyTileNBT(selection, (nbt) => {}) is deprecated, use modifyBlockEntityNBT(selection, (nbt) => {}) instead");
            this.modifyBlockEntityNBT(selection, false, consumer);
        }

        @Deprecated(forRemoval=true)
        public void modifyTileNBT(Selection selection, Consumer<CompoundTag> consumer, boolean reDrawBlocks) {
            ConsoleJS.CLIENT.warn((Object)"[PonderJS] modifyTileNBT(selection, (nbt) => {}, reDrawBlocks) is deprecated, use modifyBlockEntityNBT(selection, reDrawBlocks, (nbt) => {}) instead");
            this.modifyBlockEntityNBT(selection, BlockEntity.class, consumer, reDrawBlocks);
        }

        public void modifyBlockEntityNBT(Selection selection, Consumer<CompoundTag> consumer) {
            this.modifyBlockEntityNBT(selection, false, consumer);
        }

        public void modifyBlockEntityNBT(Selection selection, boolean reDrawBlocks, Consumer<CompoundTag> consumer) {
            this.modifyBlockEntityNBT(selection, BlockEntity.class, consumer, reDrawBlocks);
        }

        @HideFromJS
        public void modifyBlocks(Selection selection, UnaryOperator<BlockState> stateFunc, boolean spawnParticles) {
            super.modifyBlocks(selection, stateFunc, spawnParticles);
        }

        @HideFromJS
        public void modifyBlock(BlockPos pos, UnaryOperator<BlockState> stateFunc, boolean spawnParticles) {
            super.modifyBlock(pos, stateFunc, spawnParticles);
        }

        public void removeEntity(ElementLink<EntityElement> link) {
            ExtendedSceneBuilder.this.addInstruction(scene -> {
                EntityElement resolve = (EntityElement)scene.resolve(link);
                if (resolve != null) {
                    resolve.ifPresent(Entity::m_146870_);
                }
            });
        }
    }

    public class ExtendedSpecialInstructions
    extends SceneBuilder.SpecialInstructions {
        public ExtendedSpecialInstructions() {
            super((SceneBuilder)ExtendedSceneBuilder.this);
        }

        @HideFromJS
        public void movePointOfInterest(BlockPos location) {
            super.movePointOfInterest(location);
        }
    }

    public class ExtendedOverlayInstructions
    extends SceneBuilder.OverlayInstructions {
        public ExtendedOverlayInstructions() {
            super((SceneBuilder)ExtendedSceneBuilder.this);
        }

        public CustomPonderOverlayElement addElement(int ticks) {
            final CustomPonderOverlayElement element = new CustomPonderOverlayElement();
            ExtendedSceneBuilder.this.addInstruction((PonderInstruction)new TickingInstruction(false, ticks){

                protected void firstTick(PonderScene scene) {
                    super.firstTick(scene);
                    scene.addElement((PonderElement)element);
                }
            });
            return element;
        }

        public CustomPonderOverlayElement addElement() {
            CustomPonderOverlayElement element = new CustomPonderOverlayElement();
            ExtendedSceneBuilder.this.addInstruction(ponderScene -> ponderScene.addElement((PonderElement)element));
            return element;
        }
    }
}

