/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.config.util;

import dev.toma.configuration.config.UpdateRestrictions;
import dev.toma.configuration.config.util.IDescriptionProvider;
import dev.toma.configuration.config.value.IConfigValueReadable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public abstract class NoteDescriptionProvider<T>
implements IDescriptionProvider<T> {
    public static final MutableComponent SYNCHRONIZED = Component.m_237115_((String)"text.configuration.description.synchronized");
    public static final Function<UpdateRestrictions, MutableComponent> RESTRICTION = t -> Component.m_237110_((String)"text.configuration.description.update_on", (Object[])new Object[]{t.getLabel()});

    @Override
    public List<Component> generate(IConfigValueReadable<T> value) {
        ArrayList<Component> components = new ArrayList<Component>();
        this.appendValues(value, comp -> components.add((Component)comp.m_130940_(ChatFormatting.DARK_GRAY)));
        return components;
    }

    public abstract void appendValues(IConfigValueReadable<T> var1, Consumer<MutableComponent> var2);

    public static <T> IDescriptionProvider<T> note(MutableComponent note) {
        return new SimpleNoteImpl(note);
    }

    @Override
    public boolean replaceDefaultDescription() {
        return false;
    }

    private static class SimpleNoteImpl<T>
    extends NoteDescriptionProvider<T> {
        private final MutableComponent label;

        SimpleNoteImpl(MutableComponent label) {
            this.label = label;
        }

        @Override
        public void appendValues(IConfigValueReadable<T> value, Consumer<MutableComponent> appender) {
            appender.accept(this.label);
        }
    }
}

