/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.client.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.toma.configuration.Configuration;
import dev.toma.configuration.ConfigurationSettings;
import dev.toma.configuration.client.ConfigurationClient;
import dev.toma.configuration.client.screen.ConfigSettingsScreen;
import dev.toma.configuration.client.screen.DialogScreen;
import dev.toma.configuration.client.theme.ConfigTheme;
import dev.toma.configuration.client.widget.ConfigEntryWidget;
import dev.toma.configuration.client.widget.ThemedButtonWidget;
import dev.toma.configuration.client.widget.render.TextureRenderer;
import dev.toma.configuration.config.ConfigHolder;
import dev.toma.configuration.config.io.ConfigIO;
import dev.toma.configuration.config.validate.IValidationResult;
import dev.toma.configuration.config.value.ConfigValue;
import dev.toma.configuration.config.value.ObjectValue;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public abstract class AbstractConfigScreen
extends Screen
implements ConfigEntryWidget.IValidationRenderer {
    public static final int HEADER_HEIGHT = 35;
    public static final int FOOTER_HEIGHT = 30;
    public static final Marker MARKER = MarkerManager.getMarker((String)"Screen");
    public static final Component LABEL_BACK = Component.m_237115_((String)"text.configuration.value.back");
    public static final Component LABEL_SAVE_AND_CLOSE = Component.m_237115_((String)"text.configuration.value.save_and_close");
    public static final ResourceLocation ICON_REVERT = new ResourceLocation("configuration", "textures/icons/revert.png");
    public static final ResourceLocation ICON_REVERT_DEFAULT = new ResourceLocation("configuration", "textures/icons/revert_default.png");
    public static final ResourceLocation ICON_APPLY = new ResourceLocation("configuration", "textures/icons/apply.png");
    protected final ConfigHolder<?> holder;
    protected final ConfigTheme theme;
    protected final Screen last;
    protected int index;
    protected int pageSize;
    private ThemedButtonWidget applyButton;
    private ThemedButtonWidget revertButton;
    private ThemedButtonWidget revertDefaultButton;

    public AbstractConfigScreen(Component title, Screen previous, ConfigHolder<?> configHolder) {
        super(title);
        this.holder = configHolder;
        this.theme = ConfigurationClient.getConfigTheme(configHolder);
        this.last = previous;
        ConfigurationSettings.loadSettings();
    }

    public String getConfigId() {
        return this.holder.getConfigId();
    }

    public void m_7379_() {
        super.m_7379_();
        this.saveConfig(true);
    }

    public static void renderScrollbar(GuiGraphics graphics, int x, int y, int width, int height, int index, int valueCount, int paging, int bgColor) {
        if (valueCount <= paging) {
            return;
        }
        double step = (double)height / (double)valueCount;
        int min = Mth.m_14107_((double)((double)index * step));
        int max = Mth.m_14165_((double)((double)(index + paging) * step));
        int y1 = y + min;
        int y2 = y + max;
        graphics.m_280509_(x, y, x + width, y + height, bgColor);
        graphics.m_280509_(x, y1, x + width, y2, -7829368);
        graphics.m_280509_(x, y1, x + width - 1, y2 - 1, -1118482);
        graphics.m_280509_(x + 1, y1 + 1, x + width - 1, y2 - 1, -3355444);
    }

    protected void addSettingsButton() {
        ThemedButtonWidget settings = (ThemedButtonWidget)this.m_142416_((GuiEventListener)new ThemedButtonWidget(this.f_96543_ - 25, 5, 20, 20, (Component)Component.m_237113_((String)"..."), this.theme));
        settings.setBackgroundRenderer(this.theme.getButtonBackground(settings));
        settings.setClickListener((widget, mouseX, mouseY) -> {
            ConfigSettingsScreen settingsScreen = new ConfigSettingsScreen(this);
            this.f_96541_.m_91152_((Screen)settingsScreen);
        });
        settings.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"options.title")));
        settings.m_257427_(300);
    }

    protected void addFooter() {
        int centerY = this.f_96544_ - 30 + 5;
        Component backLabel = this.isRoot() ? LABEL_SAVE_AND_CLOSE : LABEL_BACK;
        ThemedButtonWidget backButton = (ThemedButtonWidget)this.m_142416_((GuiEventListener)new ThemedButtonWidget(5, centerY, 120, 20, backLabel, this.theme));
        backButton.setBackgroundRenderer(this.theme.getButtonBackground(backButton));
        backButton.setClickListener((widget, mouseX, mouseY) -> this.buttonBackClicked());
        this.applyButton = (ThemedButtonWidget)this.m_142416_((GuiEventListener)new ThemedButtonWidget(this.f_96543_ - 25, centerY, 20, 20, CommonComponents.f_237098_, this.theme));
        this.applyButton.setBackgroundRenderer(this.theme.getButtonBackground(this.applyButton));
        this.applyButton.setForegroundRenderer(new TextureRenderer(ICON_APPLY, 2, 2, 16, 16));
        this.applyButton.setClickListener((widget, mouseX, mouseY) -> {
            if (this.holder.isChanged()) {
                this.holder.save();
                this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
            }
        });
        this.applyButton.m_257544_(Tooltip.m_257550_((Component)ConfigEntryWidget.APPLY));
        this.applyButton.m_257427_(300);
        this.applyButton.f_93623_ = this.holder.isChanged();
        this.revertDefaultButton = (ThemedButtonWidget)this.m_142416_((GuiEventListener)new ThemedButtonWidget(this.f_96543_ - 50, centerY, 20, 20, CommonComponents.f_237098_, this.theme));
        this.revertDefaultButton.setBackgroundRenderer(this.theme.getButtonBackground(this.revertDefaultButton));
        this.revertDefaultButton.setForegroundRenderer(new TextureRenderer(ICON_REVERT_DEFAULT, 2, 2, 16, 16));
        this.revertDefaultButton.setClickListener((widget, mouseX, mouseY) -> this.buttonRevertToDefaultClicked());
        this.revertDefaultButton.m_257544_(Tooltip.m_257550_((Component)ConfigEntryWidget.REVERT_DEFAULTS));
        this.revertDefaultButton.m_257427_(300);
        this.revertDefaultButton.f_93623_ = this.holder.isChangedFromDefault();
        this.revertButton = (ThemedButtonWidget)this.m_142416_((GuiEventListener)new ThemedButtonWidget(this.f_96543_ - 75, centerY, 20, 20, CommonComponents.f_237098_, this.theme));
        this.revertButton.setBackgroundRenderer(this.theme.getButtonBackground(this.revertButton));
        this.revertButton.setForegroundRenderer(new TextureRenderer(ICON_REVERT, 2, 2, 16, 16));
        this.revertButton.setClickListener((widget, mouseX, mouseY) -> this.buttonRevertChangesClicked());
        this.revertButton.m_257544_(Tooltip.m_257550_((Component)ConfigEntryWidget.REVERT_CHANGES));
        this.revertButton.m_257427_(300);
        this.revertButton.f_93623_ = this.holder.isChanged();
    }

    public void m_86600_() {
        if (this.applyButton != null) {
            this.applyButton.f_93623_ = this.holder.isChanged();
        }
        if (this.revertDefaultButton != null) {
            this.revertDefaultButton.f_93623_ = this.holder.isChangedFromDefault();
        }
        if (this.revertButton != null) {
            this.revertButton.f_93623_ = this.holder.isChanged();
        }
    }

    protected void correctScrollingIndex(int count) {
        if (this.index + this.pageSize > count) {
            this.index = Math.max(count - this.pageSize, 0);
        }
    }

    protected boolean isRoot() {
        return !(this.last instanceof AbstractConfigScreen);
    }

    private void buttonBackClicked() {
        this.f_96541_.m_91152_(this.last);
        this.saveConfig();
    }

    private void buttonRevertToDefaultClicked() {
        DialogScreen dialog = new DialogScreen(ConfigEntryWidget.REVERT_DEFAULTS, new Component[]{ConfigEntryWidget.REVERT_DEFAULTS_DIALOG_TEXT}, this);
        dialog.onConfirmed(screen -> {
            Configuration.LOGGER.info(MARKER, "Reverting config {} to default values", (Object)this.getConfigId());
            this.revertToDefault(this.holder.values());
            ConfigIO.saveClientValues(this.holder);
            dialog.displayPreviousScreen();
        });
        this.f_96541_.m_91152_((Screen)dialog);
    }

    private void buttonRevertChangesClicked() {
        DialogScreen dialog = new DialogScreen(ConfigEntryWidget.REVERT_CHANGES, new Component[]{ConfigEntryWidget.REVERT_CHANGES_DIALOG_TEXT}, this);
        dialog.onConfirmed(screen -> {
            ConfigIO.reloadClientValues(this.holder);
            dialog.displayPreviousScreen();
        });
        this.f_96541_.m_91152_((Screen)dialog);
    }

    private void revertToDefault(Collection<ConfigValue<?>> configValues) {
        configValues.forEach(val -> {
            if (val instanceof ObjectValue) {
                ObjectValue objVal = (ObjectValue)val;
                this.revertToDefault(((Map)objVal.get()).values());
            } else if (val.isChangedFromDefault()) {
                val.forceSetDefaultValue();
            }
        });
    }

    private void saveConfig() {
        this.saveConfig(false);
    }

    private void saveConfig(boolean force) {
        if (force || this.isRoot()) {
            ConfigIO.saveClientValues(this.holder);
        }
    }

    @Override
    public void drawDescription(GuiGraphics graphics, AbstractWidget widget, List<FormattedCharSequence> text, IValidationResult.Severity severity, int textColor) {
        this.renderValidationText(severity, graphics, text, widget.m_252754_() + 5, widget.m_252907_() + widget.m_93694_() + 10, textColor);
    }

    @Override
    public void drawIcon(GuiGraphics graphics, AbstractWidget widget, IValidationResult.Severity severity) {
        this.renderValidationIcon(severity, graphics, widget, widget.m_252754_() - 22, widget.m_252907_() + 1);
    }

    public void renderValidationIcon(IValidationResult.Severity severity, GuiGraphics graphics, AbstractWidget widget, int x, int y) {
        ResourceLocation icon = severity.iconPath;
        graphics.m_280398_(icon, x, y, 0, 0.0f, 0.0f, 16, 16, 16, 16);
    }

    public void renderValidationText(IValidationResult.Severity severity, GuiGraphics graphics, List<FormattedCharSequence> texts, int mouseX, int mouseY, int textColor) {
        if (!texts.isEmpty()) {
            int maxTextWidth = 0;
            for (FormattedCharSequence textComponent : texts) {
                int textWidth = this.f_96547_.m_92724_(textComponent);
                if (textWidth <= maxTextWidth) continue;
                maxTextWidth = textWidth;
            }
            int startX = mouseX + 12;
            int startY = mouseY - 12;
            int heightOffset = 8;
            if (texts.size() > 1) {
                heightOffset += 2 + (texts.size() - 1) * 10;
            }
            if (startX + maxTextWidth > this.f_96543_) {
                startX -= 28 + maxTextWidth;
            }
            if (startY + heightOffset + 6 > this.f_96544_) {
                startY = this.f_96544_ - heightOffset - 6;
            }
            PoseStack stack = graphics.m_280168_();
            stack.m_85836_();
            int background = severity.backgroundColor;
            int fadeMin = severity.backgroundFadeMinColor;
            int fadeMax = severity.backgroundFadeMaxColor;
            int zIndex = 400;
            graphics.m_280120_(startX - 3, startY - 4, startX + maxTextWidth + 3, startY - 3, zIndex, background, background);
            graphics.m_280120_(startX - 3, startY + heightOffset + 3, startX + maxTextWidth + 3, startY + heightOffset + 4, zIndex, background, background);
            graphics.m_280120_(startX - 3, startY - 3, startX + maxTextWidth + 3, startY + heightOffset + 3, zIndex, background, background);
            graphics.m_280120_(startX - 4, startY - 3, startX - 3, startY + heightOffset + 3, zIndex, background, background);
            graphics.m_280120_(startX + maxTextWidth + 3, startY - 3, startX + maxTextWidth + 4, startY + heightOffset + 3, zIndex, background, background);
            graphics.m_280120_(startX - 3, startY - 3 + 1, startX - 3 + 1, startY + heightOffset + 3 - 1, zIndex, fadeMin, fadeMax);
            graphics.m_280120_(startX + maxTextWidth + 2, startY - 3 + 1, startX + maxTextWidth + 3, startY + heightOffset + 3 - 1, zIndex, fadeMin, fadeMax);
            graphics.m_280120_(startX - 3, startY - 3, startX + maxTextWidth + 3, startY - 3 + 1, zIndex, fadeMin, fadeMin);
            graphics.m_280120_(startX - 3, startY + heightOffset + 2, startX + maxTextWidth + 3, startY + heightOffset + 3, zIndex, fadeMax, fadeMax);
            stack.m_85837_(0.0, 0.0, (double)zIndex);
            for (int i = 0; i < texts.size(); ++i) {
                FormattedCharSequence textComponent = texts.get(i);
                graphics.m_280649_(this.f_96547_, textComponent, startX, startY, textColor, false);
                if (i == 0) {
                    startY += 2;
                }
                startY += 10;
            }
            stack.m_85849_();
        }
    }
}

