/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.toma.configuration.Configuration;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;

public final class ConfigurationSettings {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final File OPTIONS_FILE = new File("./config/configuration-options.json");
    private static final ConfigurationSettings INSTANCE = new ConfigurationSettings();
    private boolean advancedMode = false;

    public static ConfigurationSettings getInstance() {
        return INSTANCE;
    }

    public static void loadSettings() {
        try {
            OPTIONS_FILE.getParentFile().mkdirs();
            if (!OPTIONS_FILE.exists()) {
                ConfigurationSettings.saveSettings();
                return;
            }
            try (FileReader reader = new FileReader(OPTIONS_FILE);){
                ConfigurationSettings settings = (ConfigurationSettings)GSON.fromJson((Reader)reader, ConfigurationSettings.class);
                INSTANCE.setAdvancedMode(settings.isAdvancedMode());
            }
        }
        catch (Exception e) {
            Configuration.LOGGER.error("Failed to load configuration options, defaults will be used", (Throwable)e);
        }
    }

    public static void saveSettings() {
        try {
            OPTIONS_FILE.getParentFile().mkdirs();
            try (FileWriter writer = new FileWriter(OPTIONS_FILE);){
                GSON.toJson((Object)INSTANCE, (Appendable)writer);
            }
        }
        catch (Exception e) {
            Configuration.LOGGER.error("Failed to save configuration options", (Throwable)e);
        }
    }

    public void setAdvancedMode(boolean advancedMode) {
        this.advancedMode = advancedMode;
    }

    public boolean isAdvancedMode() {
        return this.advancedMode;
    }
}

