/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.node;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.api.network.node.ICoverable;
import com.refinedmods.refinedstorage.api.network.node.INetworkNode;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.apiimpl.network.node.NetworkNode;
import com.refinedmods.refinedstorage.apiimpl.network.node.cover.CoverManager;
import com.refinedmods.refinedstorage.blockentity.DiskDriveBlockEntity;
import com.refinedmods.refinedstorage.blockentity.config.IComparable;
import com.refinedmods.refinedstorage.blockentity.config.IType;
import com.refinedmods.refinedstorage.blockentity.config.IWhitelistBlacklist;
import com.refinedmods.refinedstorage.inventory.fluid.FluidInventory;
import com.refinedmods.refinedstorage.inventory.item.BaseItemHandler;
import com.refinedmods.refinedstorage.inventory.item.UpgradeItemHandler;
import com.refinedmods.refinedstorage.inventory.listener.InventoryListener;
import com.refinedmods.refinedstorage.inventory.listener.NetworkNodeFluidInventoryListener;
import com.refinedmods.refinedstorage.inventory.listener.NetworkNodeInventoryListener;
import com.refinedmods.refinedstorage.item.UpgradeItem;
import com.refinedmods.refinedstorage.util.LevelUtils;
import com.refinedmods.refinedstorage.util.StackUtils;
import com.ultramega.cabletiers.CableTier;
import com.ultramega.cabletiers.ContentType;
import com.ultramega.cabletiers.blockentity.TieredImporterBlockEntity;
import com.ultramega.cabletiers.node.TieredNetworkNode;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TieredImporterNetworkNode
extends TieredNetworkNode<TieredImporterNetworkNode>
implements IComparable,
IWhitelistBlacklist,
IType,
ICoverable {
    private static final String NBT_COMPARE = "Compare";
    private static final String NBT_MODE = "Mode";
    private static final String NBT_TYPE = "Type";
    private static final String NBT_FLUID_FILTERS = "FluidFilters";
    private static final int BASE_SPEED = 9;
    private final BaseItemHandler itemFilters = new BaseItemHandler(9 * this.getTier().getSlotsMultiplier()).addListener((InventoryListener)new NetworkNodeInventoryListener((INetworkNode)this));
    private final FluidInventory fluidFilters = new FluidInventory(9 * this.getTier().getSlotsMultiplier()).addListener((InventoryListener)new NetworkNodeFluidInventoryListener((INetworkNode)this));
    private final UpgradeItemHandler upgrades = (UpgradeItemHandler)new UpgradeItemHandler(4, this.getTierUpgrades()).addListener((InventoryListener)new NetworkNodeInventoryListener((INetworkNode)this));
    private int compare = 1;
    private int mode = 1;
    private int type = 0;
    private int currentSlot;
    private final CoverManager coverManager = new CoverManager((NetworkNode)this);
    private final double speedMultiplier = this.getSpeedMultiplier(1);

    public TieredImporterNetworkNode(Level level, BlockPos pos, CableTier tier) {
        super(level, pos, ContentType.IMPORTER, tier);
    }

    private UpgradeItem.Type[] getTierUpgrades() {
        UpgradeItem.Type[] typeArray;
        switch (this.getTier()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case ELITE: {
                UpgradeItem.Type[] typeArray2 = new UpgradeItem.Type[2];
                typeArray2[0] = UpgradeItem.Type.SPEED;
                typeArray = typeArray2;
                typeArray2[1] = UpgradeItem.Type.STACK;
                break;
            }
            case ULTRA: 
            case MEGA: {
                UpgradeItem.Type[] typeArray3 = new UpgradeItem.Type[1];
                typeArray = typeArray3;
                typeArray3[0] = UpgradeItem.Type.SPEED;
            }
        }
        return typeArray;
    }

    public int getEnergyUsage() {
        return 4 * (RS.SERVER_CONFIG.getImporter().getUsage() + this.upgrades.getEnergyUsage()) * this.getAdditionalEnergyCost();
    }

    public void update() {
        FluidStack extracted;
        FluidStack extractedSimulated;
        IFluidHandler handler;
        super.update();
        if (!(this.canUpdate() && this.level.m_46749_(this.pos) && this.level.m_46749_(this.pos.m_121945_(this.getDirection())))) {
            return;
        }
        int speed = Math.max(0, this.upgrades.getSpeed((int)(9.0 / this.speedMultiplier), 2));
        if (speed != 0 && this.ticks % speed != 0) {
            return;
        }
        if (this.type == 0) {
            BlockEntity facing = this.getFacingBlockEntity();
            IItemHandler handler2 = LevelUtils.getItemHandler((BlockEntity)facing, (Direction)this.getDirection().m_122424_());
            if (facing instanceof DiskDriveBlockEntity || handler2 == null) {
                return;
            }
            if (this.currentSlot >= handler2.getSlots()) {
                this.currentSlot = 0;
            }
            if (handler2.getSlots() > 0) {
                while (this.currentSlot + 1 < handler2.getSlots() && handler2.getStackInSlot(this.currentSlot).m_41619_()) {
                    ++this.currentSlot;
                }
                ItemStack stack = handler2.getStackInSlot(this.currentSlot);
                if (!IWhitelistBlacklist.acceptsItem((IItemHandler)this.itemFilters, (int)this.mode, (int)this.compare, (ItemStack)stack)) {
                    ++this.currentSlot;
                } else {
                    ItemStack result = handler2.extractItem(this.currentSlot, this.getTieredStackInteractCount(this.upgrades), true);
                    if (!result.m_41619_() && this.network.insertItem(result, result.m_41613_(), Action.SIMULATE).m_41619_()) {
                        result = handler2.extractItem(this.currentSlot, this.getTieredStackInteractCount(this.upgrades), false);
                        this.network.insertItemTracked(result, result.m_41613_());
                    } else {
                        ++this.currentSlot;
                    }
                }
            }
        } else if (this.type == 1 && (handler = LevelUtils.getFluidHandler((BlockEntity)this.getFacingBlockEntity(), (Direction)this.getDirection().m_122424_())) != null && !(extractedSimulated = handler.drain(1000 * this.getTieredStackInteractCount(this.upgrades), IFluidHandler.FluidAction.SIMULATE)).isEmpty() && IWhitelistBlacklist.acceptsFluid((FluidInventory)this.fluidFilters, (int)this.mode, (int)this.compare, (FluidStack)extractedSimulated) && this.network.insertFluid(extractedSimulated, extractedSimulated.getAmount(), Action.SIMULATE).isEmpty() && !(extracted = handler.drain(extractedSimulated, IFluidHandler.FluidAction.EXECUTE)).isEmpty()) {
            this.network.insertFluidTracked(extracted, extracted.getAmount());
        }
    }

    public int getCompare() {
        return this.compare;
    }

    public void setCompare(int compare) {
        this.compare = compare;
        this.markDirty();
    }

    public int getWhitelistBlacklistMode() {
        return this.mode;
    }

    public void setWhitelistBlacklistMode(int mode) {
        this.mode = mode;
        this.markDirty();
    }

    public CompoundTag write(CompoundTag tag) {
        super.write(tag);
        tag.m_128365_(CoverManager.NBT_COVER_MANAGER, (Tag)this.coverManager.writeToNbt());
        StackUtils.writeItems((IItemHandler)this.upgrades, (int)1, (CompoundTag)tag);
        return tag;
    }

    public CompoundTag writeConfiguration(CompoundTag tag) {
        super.writeConfiguration(tag);
        tag.m_128405_(NBT_COMPARE, this.compare);
        tag.m_128405_(NBT_MODE, this.mode);
        tag.m_128405_(NBT_TYPE, this.type);
        StackUtils.writeItems((IItemHandler)this.itemFilters, (int)0, (CompoundTag)tag);
        tag.m_128365_(NBT_FLUID_FILTERS, (Tag)this.fluidFilters.writeToNbt());
        return tag;
    }

    public void read(CompoundTag tag) {
        super.read(tag);
        if (tag.m_128441_(CoverManager.NBT_COVER_MANAGER)) {
            this.coverManager.readFromNbt(tag.m_128469_(CoverManager.NBT_COVER_MANAGER));
        }
        StackUtils.readItems((BaseItemHandler)this.upgrades, (int)1, (CompoundTag)tag);
    }

    public void readConfiguration(CompoundTag tag) {
        super.readConfiguration(tag);
        if (tag.m_128441_(NBT_COMPARE)) {
            this.compare = tag.m_128451_(NBT_COMPARE);
        }
        if (tag.m_128441_(NBT_MODE)) {
            this.mode = tag.m_128451_(NBT_MODE);
        }
        if (tag.m_128441_(NBT_TYPE)) {
            this.type = tag.m_128451_(NBT_TYPE);
        }
        StackUtils.readItems((BaseItemHandler)this.itemFilters, (int)0, (CompoundTag)tag);
        if (tag.m_128441_(NBT_FLUID_FILTERS)) {
            this.fluidFilters.readFromNbt(tag.m_128469_(NBT_FLUID_FILTERS));
        }
    }

    public UpgradeItemHandler getUpgrades() {
        return this.upgrades;
    }

    public IItemHandler getDrops() {
        return this.upgrades;
    }

    public int getType() {
        return this.level.f_46443_ ? (Integer)TieredImporterBlockEntity.TYPE.getValue() : this.type;
    }

    public void setType(int type) {
        this.type = type;
        this.markDirty();
    }

    public IItemHandlerModifiable getItemFilters() {
        return this.itemFilters;
    }

    public FluidInventory getFluidFilters() {
        return this.fluidFilters;
    }

    public CoverManager getCoverManager() {
        return this.coverManager;
    }
}

