/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.allthearcanistgear.datagen;

import com.github.jarva.allthearcanistgear.AllTheArcanistGear;
import com.github.jarva.allthearcanistgear.common.armor.ArcanistArmorSet;
import com.github.jarva.allthearcanistgear.common.recipes.PerkTierIngredient;
import com.github.jarva.allthearcanistgear.datagen.ConditionalRecipeOutput;
import com.github.jarva.allthearcanistgear.datagen.ItemTagDatagen;
import com.github.jarva.allthearcanistgear.setup.registry.AddonItemRegistry;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionBuilder;

public class RecipeDatagen
extends RecipeProvider
implements IConditionBuilder {
    public RecipeDatagen(PackOutput packOutput) {
        super(packOutput);
    }

    protected void m_245200_(Consumer<FinishedRecipe> consumer) {
        ConditionalRecipeOutput output = new ConditionalRecipeOutput(consumer);
        ConditionalRecipeOutput withATM = output.withCondition(this.modLoaded("allthemodium"));
        this.smithing(withATM, AddonItemRegistry.ALLTHEMODIUM, ItemTagDatagen.ALLTHEMODIUM_SMITHING_TEMPLATE, ItemTagDatagen.ALLTHEMODIUM_INGOT);
        this.smithing(withATM, AddonItemRegistry.VIBRANIUM, ItemTagDatagen.VIBRANIUM_SMITHING_TEMPLATE, AddonItemRegistry.ALLTHEMODIUM, ItemTagDatagen.VIBRANIUM_INGOT);
        this.smithing(withATM, AddonItemRegistry.UNOBTAINIUM, ItemTagDatagen.UNOBTAINIUM_SMITHING_TEMPLATE, AddonItemRegistry.VIBRANIUM, ItemTagDatagen.UNOBTAINIUM_INGOT);
    }

    private void smithing(ConditionalRecipeOutput consumer, ArcanistArmorSet set, TagKey<Item> template, TagKey<Item> modifier) {
        ICondition elementalLoaded = this.modLoaded("ars_elemental");
        ConditionalRecipeOutput withElemental = consumer.withCondition(elementalLoaded);
        this.smithing(withElemental, set.getHat(), template, ItemTagDatagen.ELEMENTAL_HAT, modifier, 0);
        this.smithing(withElemental, set.getChest(), template, ItemTagDatagen.ELEMENTAL_CHEST, modifier, 0);
        this.smithing(withElemental, set.getLegs(), template, ItemTagDatagen.ELEMENTAL_LEGS, modifier, 0);
        this.smithing(withElemental, set.getBoots(), template, ItemTagDatagen.ELEMENTAL_BOOTS, modifier, 0);
        ConditionalRecipeOutput withoutElemental = consumer.withCondition(this.not(elementalLoaded));
        this.smithing(withoutElemental, set.getHat(), template, ItemTagDatagen.BASE_HAT, modifier, 2);
        this.smithing(withoutElemental, set.getChest(), template, ItemTagDatagen.BASE_CHEST, modifier, 2);
        this.smithing(withoutElemental, set.getLegs(), template, ItemTagDatagen.BASE_LEGS, modifier, 2);
        this.smithing(withoutElemental, set.getBoots(), template, ItemTagDatagen.BASE_BOOTS, modifier, 2);
    }

    private Ingredient minTier(TagKey<Item> base, int tier) {
        return tier > 0 ? new PerkTierIngredient(base, tier) : Ingredient.m_204132_(base);
    }

    private void smithing(ConditionalRecipeOutput consumer, ArcanistArmorSet set, TagKey<Item> template, ArcanistArmorSet base, TagKey<Item> modifier) {
        this.smithing(consumer, set.getHat(), template, base.getHat(), modifier);
        this.smithing(consumer, set.getChest(), template, base.getChest(), modifier);
        this.smithing(consumer, set.getLegs(), template, base.getLegs(), modifier);
        this.smithing(consumer, set.getBoots(), template, base.getBoots(), modifier);
    }

    private void smithing(ConditionalRecipeOutput consumer, Item armor, TagKey<Item> template, Item base, TagKey<Item> modifier) {
        SmithingTransformRecipeBuilder.m_266555_((Ingredient)Ingredient.m_204132_(template), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{base}), (Ingredient)Ingredient.m_204132_(modifier), (RecipeCategory)RecipeCategory.COMBAT, (Item)armor).m_266439_("allthearcanistgear:has_" + modifier.f_203868_().m_135815_() + "_ingot", (CriterionTriggerInstance)RecipeDatagen.m_206406_(modifier)).m_266371_((Consumer)consumer, AllTheArcanistGear.prefix(RecipeDatagen.m_176632_((ItemLike)armor) + "_smithing"));
    }

    private void smithing(ConditionalRecipeOutput consumer, Item armor, TagKey<Item> template, TagKey<Item> base, TagKey<Item> modifier, int tier) {
        this.smithing(consumer, armor, template, this.minTier(base, tier), modifier, base.f_203868_().m_135815_());
    }

    private void smithing(ConditionalRecipeOutput consumer, Item armor, TagKey<Item> template, Ingredient base, TagKey<Item> modifier, String baseName) {
        SmithingTransformRecipeBuilder.m_266555_((Ingredient)Ingredient.m_204132_(template), (Ingredient)base, (Ingredient)Ingredient.m_204132_(modifier), (RecipeCategory)RecipeCategory.COMBAT, (Item)armor).m_266439_("allthearcanistgear:has_" + modifier.f_203868_().m_135815_() + "_ingot", (CriterionTriggerInstance)RecipeDatagen.m_206406_(modifier)).m_266371_((Consumer)consumer, AllTheArcanistGear.prefix(baseName + "_to_" + RecipeDatagen.m_176632_((ItemLike)armor) + "_smithing"));
    }
}

