/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.recipe;

import ca.teamdman.sfm.common.blockentity.PrintingPressBlockEntity;
import ca.teamdman.sfm.common.item.FormItem;
import ca.teamdman.sfm.common.registry.SFMRecipeSerializers;
import ca.teamdman.sfm.common.registry.SFMRecipeTypes;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class PrintingPressRecipe
implements Recipe<PrintingPressBlockEntity> {
    public final ResourceLocation ID;
    public final Ingredient FORM;
    public final Ingredient INK;
    public final Ingredient PAPER;

    public PrintingPressRecipe(ResourceLocation id, Ingredient form, Ingredient ink, Ingredient paper) {
        this.ID = id;
        this.FORM = form;
        this.INK = ink;
        this.PAPER = paper;
    }

    public boolean matches(PrintingPressBlockEntity pContainer, Level pLevel) {
        return this.PAPER.test(pContainer.getPaper()) && this.INK.test(pContainer.getInk()) && this.FORM.test(FormItem.getReference(pContainer.getForm()));
    }

    public ItemStack assemble(PrintingPressBlockEntity pContainer, RegistryAccess p_267165_) {
        ItemStack rtn = FormItem.getReference(pContainer.getForm());
        rtn.m_41764_(pContainer.getPaper().m_41613_());
        return rtn;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess p_267052_) {
        return ItemStack.f_41583_;
    }

    public ResourceLocation m_6423_() {
        return this.ID;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)SFMRecipeSerializers.PRINTING_PRESS.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)SFMRecipeTypes.PRINTING_PRESS.get();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        PrintingPressRecipe that = (PrintingPressRecipe)obj;
        return Objects.equals(this.ID, that.ID) && Objects.equals(this.FORM, that.FORM) && Objects.equals(this.INK, that.INK) && Objects.equals(this.PAPER, that.PAPER);
    }

    public int hashCode() {
        return Objects.hash(this.ID, this.FORM, this.INK, this.PAPER);
    }

    public String toString() {
        return "PrintingPressRecipe[id=" + this.ID + ", form=" + this.FORM + ", ink=" + this.INK + ", paper=" + this.PAPER + "]";
    }

    public static class Serializer
    implements RecipeSerializer<PrintingPressRecipe> {
        public PrintingPressRecipe fromJson(ResourceLocation pRecipeId, JsonObject pSerializedRecipe) {
            Ingredient form = Ingredient.m_43917_((JsonElement)pSerializedRecipe.get("form"));
            Ingredient ink = Ingredient.m_43917_((JsonElement)pSerializedRecipe.get("ink"));
            Ingredient paper = Ingredient.m_43917_((JsonElement)pSerializedRecipe.get("paper"));
            return new PrintingPressRecipe(pRecipeId, form, ink, paper);
        }

        @Nullable
        public PrintingPressRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            Ingredient form = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            Ingredient ink = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            Ingredient paper = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            return new PrintingPressRecipe(pRecipeId, form, ink, paper);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, PrintingPressRecipe pRecipe) {
            pRecipe.FORM.m_43923_(pBuffer);
            pRecipe.INK.m_43923_(pBuffer);
            pRecipe.PAPER.m_43923_(pBuffer);
        }
    }
}

