/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.program;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.common.blockentity.ManagerBlockEntity;
import ca.teamdman.sfm.common.cablenetwork.CableNetworkManager;
import ca.teamdman.sfm.common.item.DiskItem;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.program.GatherWarningsProgramBehaviour;
import ca.teamdman.sfm.common.program.LabelPositionHolder;
import ca.teamdman.sfm.common.program.ProgramContext;
import ca.teamdman.sfm.common.resourcetype.ResourceType;
import ca.teamdman.sfm.common.util.SFMUtils;
import ca.teamdman.sfml.ast.IOStatement;
import ca.teamdman.sfml.ast.Program;
import ca.teamdman.sfml.ast.ResourceIdentifier;
import ca.teamdman.sfml.ast.ResourceQuantity;
import ca.teamdman.sfml.ast.RoundRobin;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProgramLinter {
    public static ArrayList<TranslatableContents> gatherWarnings(Program program, LabelPositionHolder labelPositionHolder, @Nullable ManagerBlockEntity manager) {
        ArrayList<TranslatableContents> warnings = new ArrayList<TranslatableContents>();
        Level level = manager != null ? manager.m_58904_() : null;
        ProgramLinter.addWarningsForLabelsInProgramButNotInHolder(program, labelPositionHolder, warnings);
        ProgramLinter.addWarningsForLabelsInHolderButNotInProgram(program, labelPositionHolder, warnings);
        if (level != null) {
            ProgramLinter.addWarningsForLabelsUsedInWorldButNotConnectedByCables(manager, labelPositionHolder, warnings, level);
        }
        ProgramLinter.addWarningsForUsingIOWithoutCorrespondingOppositeIO(program, labelPositionHolder, warnings);
        ProgramLinter.addWarningsForResourcesReferencedButNotFoundInRegistry(program, warnings);
        program.getDescendantStatements().filter(IOStatement.class::isInstance).map(IOStatement.class::cast).forEach(statement -> {
            ProgramLinter.addWarningsForSmellyRoundRobinUsage(warnings, statement);
            ProgramLinter.addWarningsForUsingEachWithoutAPattern(warnings, statement);
        });
        return warnings;
    }

    public static void fixWarningsByRemovingBadLabelsFromDisk(ManagerBlockEntity manager, ItemStack disk, Program program) {
        LabelPositionHolder labels = LabelPositionHolder.from(disk);
        labels.removeIf(label -> !program.referencedLabels().contains(label));
        CableNetworkManager.getOrRegisterNetworkFromManagerPosition(manager).ifPresent(network -> labels.removeIf((label, pos) -> !network.isAdjacentToCable((BlockPos)pos)));
        labels.save(disk);
        DiskItem.setWarnings(disk, ProgramLinter.gatherWarnings(program, labels, manager));
    }

    private static void addWarningsForUsingIOWithoutCorrespondingOppositeIO(Program program, LabelPositionHolder labelPositionHolder, ArrayList<TranslatableContents> warnings) {
        program.tick(ProgramContext.createSimulationContext(program, labelPositionHolder, 0, new GatherWarningsProgramBehaviour(warnings::addAll)));
    }

    private static void addWarningsForUsingEachWithoutAPattern(ArrayList<TranslatableContents> warnings, IOStatement statement) {
        boolean smells = statement.resourceLimits().resourceLimits().stream().anyMatch(rl -> rl.limit().quantity().idExpansionBehaviour() == ResourceQuantity.IdExpansionBehaviour.EXPAND && !rl.resourceId().usesRegex());
        if (smells) {
            warnings.add(LocalizationKeys.PROGRAM_WARNING_RESOURCE_EACH_WITHOUT_PATTERN.get(statement.toStringPretty()));
        }
    }

    private static void addWarningsForSmellyRoundRobinUsage(ArrayList<TranslatableContents> warnings, IOStatement statement) {
        RoundRobin roundRobin = statement.labelAccess().roundRobin();
        if (roundRobin.getBehaviour() == RoundRobin.Behaviour.BY_BLOCK && statement.each()) {
            warnings.add(LocalizationKeys.PROGRAM_WARNING_ROUND_ROBIN_SMELLY_EACH.get(statement.toStringPretty()));
        } else if (roundRobin.getBehaviour() == RoundRobin.Behaviour.BY_LABEL && statement.labelAccess().labels().size() == 1) {
            warnings.add(LocalizationKeys.PROGRAM_WARNING_ROUND_ROBIN_SMELLY_COUNT.get(statement.toStringPretty()));
        }
    }

    private static void addWarningsForResourcesReferencedButNotFoundInRegistry(Program program, ArrayList<TranslatableContents> warnings) {
        for (ResourceIdentifier<?, ?, ?> resource : program.referencedResources()) {
            Optional<ResourceLocation> loc = resource.getLocation();
            if (loc.isEmpty()) continue;
            ResourceType<?, ?, ?> type = resource.getResourceType();
            if (type == null) {
                SFM.LOGGER.error("Resource type not found for resource: {}, should have been validated at program compile", resource);
                continue;
            }
            if (type.registryKeyExists(loc.get())) continue;
            warnings.add(LocalizationKeys.PROGRAM_WARNING_UNKNOWN_RESOURCE_ID.get(resource));
        }
    }

    private static void addWarningsForLabelsUsedInWorldButNotConnectedByCables(@NotNull ManagerBlockEntity manager, LabelPositionHolder labels, ArrayList<TranslatableContents> warnings, Level level) {
        CableNetworkManager.getOrRegisterNetworkFromManagerPosition(manager).ifPresent(network -> labels.forEach((label, pos) -> {
            boolean viable;
            boolean adjacent = network.isAdjacentToCable((BlockPos)pos);
            if (!adjacent) {
                warnings.add(LocalizationKeys.PROGRAM_WARNING_DISCONNECTED_LABEL.get(label, String.format("[%d,%d,%d]", pos.m_123341_(), pos.m_123342_(), pos.m_123343_())));
            }
            if (!(viable = SFMUtils.discoverCapabilityProvider(level, pos).isPresent()) && adjacent) {
                warnings.add(LocalizationKeys.PROGRAM_WARNING_CONNECTED_BUT_NOT_VIABLE_LABEL.get(label, String.format("[%d,%d,%d]", pos.m_123341_(), pos.m_123342_(), pos.m_123343_())));
            }
        }));
    }

    private static void addWarningsForLabelsInHolderButNotInProgram(Program program, LabelPositionHolder labels, ArrayList<TranslatableContents> warnings) {
        labels.get().keySet().stream().filter(x -> !program.referencedLabels().contains(x)).forEach(label -> warnings.add(LocalizationKeys.PROGRAM_WARNING_UNDEFINED_LABEL.get(label)));
    }

    private static void addWarningsForLabelsInProgramButNotInHolder(Program program, LabelPositionHolder labels, ArrayList<TranslatableContents> warnings) {
        for (String label : program.referencedLabels()) {
            boolean isUsed = !labels.getPositions(label).isEmpty();
            if (isUsed) continue;
            warnings.add(LocalizationKeys.PROGRAM_WARNING_UNUSED_LABEL.get(label));
        }
    }
}

