/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.net;

import ca.teamdman.sfm.common.cablenetwork.CableNetwork;
import ca.teamdman.sfm.common.cablenetwork.CableNetworkManager;
import ca.teamdman.sfm.common.compat.SFMCompat;
import ca.teamdman.sfm.common.net.ClientboundInputInspectionResultsPacket;
import ca.teamdman.sfm.common.net.ServerboundContainerExportsInspectionRequestPacket;
import ca.teamdman.sfm.common.registry.SFMPackets;
import ca.teamdman.sfm.common.registry.SFMResourceTypes;
import ca.teamdman.sfm.common.resourcetype.ResourceType;
import ca.teamdman.sfm.common.util.SFMUtils;
import ca.teamdman.sfml.ast.DirectionQualifier;
import java.util.ArrayList;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public record ServerboundNetworkToolUsePacket(BlockPos blockPosition, Direction blockFace) {
    public static void encode(ServerboundNetworkToolUsePacket msg, FriendlyByteBuf friendlyByteBuf) {
        friendlyByteBuf.m_130064_(msg.blockPosition);
        friendlyByteBuf.m_130068_((Enum)msg.blockFace);
    }

    public static ServerboundNetworkToolUsePacket decode(FriendlyByteBuf friendlyByteBuf) {
        return new ServerboundNetworkToolUsePacket(friendlyByteBuf.m_130135_(), (Direction)friendlyByteBuf.m_130066_(Direction.class));
    }

    public static void handle(ServerboundNetworkToolUsePacket msg, Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> {
            BlockPos pos;
            ServerPlayer player = ((NetworkEvent.Context)contextSupplier.get()).getSender();
            if (player == null) {
                return;
            }
            Level level = player.m_9236_();
            if (!level.m_46749_(pos = msg.blockPosition())) {
                return;
            }
            StringBuilder payload = new StringBuilder().append("---- block position ----\n").append(pos).append("\n---- block state ----\n");
            BlockState state = level.m_8055_(pos);
            payload.append(state).append("\n");
            ArrayList foundNetworks = new ArrayList();
            for (Direction direction : Direction.values()) {
                BlockPos cablePosition = pos.m_121945_(direction);
                CableNetworkManager.getOrRegisterNetworkFromCablePosition(level, cablePosition).ifPresent(foundNetworks::add);
            }
            payload.append("---- cable networks ----\n");
            if (foundNetworks.isEmpty()) {
                payload.append("No networks found\n");
            } else {
                for (CableNetwork network : foundNetworks) {
                    payload.append(network).append("\n");
                }
            }
            BlockEntity entity = level.m_7702_(pos);
            if (entity != null) {
                if (!FMLEnvironment.production) {
                    payload.append("---- (dev only) block entity ----\n");
                    payload.append(entity).append("\n");
                }
                payload.append("---- capability directions ----\n");
                for (Capability<?> cap : SFMCompat.getCapabilities()) {
                    payload.append(cap.getName()).append(": ");
                    String directions = DirectionQualifier.EVERY_DIRECTION.stream().filter(dir -> entity.getCapability(cap, dir).isPresent()).map(dir -> dir == null ? "NULL DIRECTION" : DirectionQualifier.directionToString(dir)).collect(Collectors.joining(", ", "[", "]"));
                    payload.append(directions).append("\n");
                }
            }
            payload.append("---- exports ----\n");
            int len = payload.length();
            SFMResourceTypes.DEFERRED_TYPES.get().getEntries().forEach(entry -> payload.append(ServerboundContainerExportsInspectionRequestPacket.buildInspectionResults((ResourceKey)entry.getKey(), (ResourceType)entry.getValue(), level, pos, msg.blockFace)));
            if (payload.length() == len) {
                payload.append("No exports found");
            }
            payload.append("\n");
            if (entity != null && player.m_20310_(2)) {
                payload.append("---- (op only) nbt data ----\n");
                payload.append(entity.serializeNBT()).append("\n");
            }
            SFMPackets.INSPECTION_CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ClientboundInputInspectionResultsPacket(SFMUtils.truncate(payload.toString(), 20480)));
        });
        contextSupplier.get().setPacketHandled(true);
    }
}

