/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.net;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.common.containermenu.ManagerContainerMenu;
import ca.teamdman.sfm.common.logging.TranslatableLogEvent;
import ca.teamdman.sfm.common.logging.TranslatableLogger;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkEvent;

public record ClientboundManagerLogsPacket(int windowId, FriendlyByteBuf logsBuf) {
    public static ClientboundManagerLogsPacket drainToCreate(int windowId, Collection<TranslatableLogEvent> logs) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        TranslatableLogger.encodeAndDrain(logs, buf);
        return new ClientboundManagerLogsPacket(windowId, buf);
    }

    public static void encode(ClientboundManagerLogsPacket msg, FriendlyByteBuf friendlyByteBuf) {
        friendlyByteBuf.m_130130_(msg.windowId());
        friendlyByteBuf.m_130130_(msg.logsBuf.readableBytes());
        friendlyByteBuf.writeBytes((ByteBuf)msg.logsBuf, 0, msg.logsBuf.readableBytes());
    }

    public static ClientboundManagerLogsPacket decode(FriendlyByteBuf friendlyByteBuf) {
        int windowId = friendlyByteBuf.m_130242_();
        int size = friendlyByteBuf.m_130242_();
        FriendlyByteBuf logsBuf = new FriendlyByteBuf(Unpooled.buffer((int)size));
        friendlyByteBuf.readBytes((ByteBuf)logsBuf, size);
        return new ClientboundManagerLogsPacket(windowId, logsBuf);
    }

    public static void handle(ClientboundManagerLogsPacket msg, Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(msg::handle);
        contextSupplier.get().setPacketHandled(true);
    }

    public void handle() {
        ManagerContainerMenu menu;
        block3: {
            block2: {
                AbstractContainerMenu abstractContainerMenu;
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                if (player == null || !((abstractContainerMenu = player.f_36096_) instanceof ManagerContainerMenu)) break block2;
                menu = (ManagerContainerMenu)abstractContainerMenu;
                if (menu.f_38840_ == this.windowId()) break block3;
            }
            SFM.LOGGER.error("Invalid logs packet received, ignoring.");
            return;
        }
        ArrayDeque<TranslatableLogEvent> logs = TranslatableLogger.decode(this.logsBuf);
        menu.logs.addAll(logs);
    }
}

