/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.gui.screen;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.client.ClientDiagnosticInfo;
import ca.teamdman.sfm.client.ClientStuff;
import ca.teamdman.sfm.client.gui.screen.ExtendedButtonWithTooltip;
import ca.teamdman.sfm.common.blockentity.ManagerBlockEntity;
import ca.teamdman.sfm.common.containermenu.ManagerContainerMenu;
import ca.teamdman.sfm.common.item.DiskItem;
import ca.teamdman.sfm.common.localization.LocalizationEntry;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.net.ServerboundManagerFixPacket;
import ca.teamdman.sfm.common.net.ServerboundManagerProgramPacket;
import ca.teamdman.sfm.common.net.ServerboundManagerRebuildPacket;
import ca.teamdman.sfm.common.net.ServerboundManagerResetPacket;
import ca.teamdman.sfm.common.registry.SFMPackets;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.gui.widget.ExtendedButton;
import org.apache.logging.log4j.Level;
import org.joml.Matrix4f;

public class ManagerScreen
extends AbstractContainerScreen<ManagerContainerMenu> {
    private static final ResourceLocation BACKGROUND_TEXTURE_LOCATION = new ResourceLocation("sfm", "textures/gui/container/manager.png");
    private final float STATUS_DURATION = 40.0f;
    private Component status = Component.m_237119_();
    private float statusCountdown = 0.0f;
    private ExtendedButton diagButton;
    private ExtendedButton clipboardPasteButton;
    private ExtendedButton clipboardCopyButton;
    private ExtendedButton resetButton;
    private ExtendedButton editButton;
    private ExtendedButton examplesButton;
    private ExtendedButton logsButton;
    private ExtendedButton rebuildButton;

    public ManagerScreen(ManagerContainerMenu menu, Inventory inv, Component title) {
        super((AbstractContainerMenu)menu, inv, title);
    }

    public List<ExtendedButton> getButtonsForJEIExclusionZones() {
        return List.of(this.clipboardPasteButton, this.editButton, this.examplesButton, this.clipboardCopyButton, this.logsButton, this.rebuildButton);
    }

    public boolean isReadOnly() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        return player == null || player.m_5833_();
    }

    public void updateVisibilities() {
        boolean diskPresent = ((ManagerContainerMenu)this.f_97732_).m_38853_(0).m_6657_();
        this.diagButton.f_93624_ = this.shouldShowDiagButton();
        this.clipboardCopyButton.f_93624_ = diskPresent;
        this.logsButton.f_93624_ = diskPresent;
        this.rebuildButton.f_93624_ = diskPresent && !this.isReadOnly();
        this.clipboardPasteButton.f_93624_ = diskPresent && !this.isReadOnly();
        this.resetButton.f_93624_ = diskPresent && !this.isReadOnly();
        this.editButton.f_93624_ = diskPresent && !this.isReadOnly();
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        if (Screen.m_96630_((int)pKeyCode) && this.clipboardPasteButton.f_93624_) {
            this.onClipboardPasteButtonClicked();
            return true;
        }
        if (Screen.m_96632_((int)pKeyCode) && this.clipboardCopyButton.f_93624_) {
            this.onClipboardCopyButtonClicked();
            return true;
        }
        if (pKeyCode == 69 && Screen.m_96637_() && Screen.m_96638_() && this.examplesButton.f_93624_) {
            this.onExamplesButtonClicked();
            return true;
        }
        if (pKeyCode == 69 && Screen.m_96637_() && this.editButton.f_93624_) {
            this.onEditButtonClicked();
            return true;
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    public ChatFormatting getMillisecondColour(float ms) {
        if (ms <= 5.0f) {
            return ChatFormatting.GREEN;
        }
        if (ms <= 15.0f) {
            return ChatFormatting.YELLOW;
        }
        return ChatFormatting.RED;
    }

    public void m_88315_(GuiGraphics graphics, int mx, int my, float partialTicks) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mx, my, partialTicks);
        this.m_280072_(graphics, mx, my);
        this.updateVisibilities();
        this.statusCountdown -= partialTicks;
    }

    private Tooltip buildTooltip(LocalizationEntry entry) {
        return Tooltip.m_257550_((Component)entry.getComponent());
    }

    protected void m_7856_() {
        super.m_7856_();
        int buttonWidth = 120;
        this.clipboardPasteButton = (ExtendedButton)this.m_142416_((GuiEventListener)new ExtendedButtonWithTooltip((this.f_96543_ - this.f_97726_) / 2 - buttonWidth, (this.f_96544_ - this.f_97727_) / 2 + 16, buttonWidth, 16, (Component)LocalizationKeys.MANAGER_GUI_PASTE_FROM_CLIPBOARD_BUTTON.getComponent(), button -> this.onClipboardPasteButtonClicked(), this.buildTooltip(LocalizationKeys.MANAGER_GUI_PASTE_FROM_CLIPBOARD_BUTTON_TOOLTIP)));
        this.editButton = (ExtendedButton)this.m_142416_((GuiEventListener)new ExtendedButtonWithTooltip((this.f_96543_ - this.f_97726_) / 2 - buttonWidth, (this.f_96544_ - this.f_97727_) / 2 + 16 + 50, buttonWidth, 16, (Component)LocalizationKeys.MANAGER_GUI_EDIT_BUTTON.getComponent(), button -> this.onEditButtonClicked(), this.buildTooltip(LocalizationKeys.MANAGER_GUI_EDIT_BUTTON_TOOLTIP)));
        this.examplesButton = (ExtendedButton)this.m_142416_((GuiEventListener)new ExtendedButtonWithTooltip((this.f_96543_ - this.f_97726_) / 2 - buttonWidth, (this.f_96544_ - this.f_97727_) / 2 + 32 + 50, buttonWidth, 16, (Component)LocalizationKeys.MANAGER_GUI_VIEW_EXAMPLES_BUTTON.getComponent(), button -> this.onExamplesButtonClicked(), this.buildTooltip(LocalizationKeys.MANAGER_GUI_VIEW_EXAMPLES_BUTTON_TOOLTIP)));
        this.clipboardCopyButton = (ExtendedButton)this.m_142416_((GuiEventListener)new ExtendedButton((this.f_96543_ - this.f_97726_) / 2 - buttonWidth, (this.f_96544_ - this.f_97727_) / 2 + 128, buttonWidth, 16, (Component)LocalizationKeys.MANAGER_GUI_COPY_TO_CLIPBOARD_BUTTON.getComponent(), button -> this.onClipboardCopyButtonClicked()));
        this.logsButton = (ExtendedButton)this.m_142416_((GuiEventListener)new ExtendedButton((this.f_96543_ - this.f_97726_) / 2 - buttonWidth, (this.f_96544_ - this.f_97727_) / 2 + 144, buttonWidth, 16, (Component)LocalizationKeys.MANAGER_GUI_VIEW_LOGS_BUTTON.getComponent(), button -> this.onLogsButtonClicked()));
        this.rebuildButton = (ExtendedButton)this.m_142416_((GuiEventListener)new ExtendedButton((this.f_96543_ - this.f_97726_) / 2 - buttonWidth, (this.f_96544_ - this.f_97727_) / 2 + 160, buttonWidth, 16, (Component)LocalizationKeys.MANAGER_GUI_REBUILD_BUTTON.getComponent(), button -> this.onRebuildButtonClicked()));
        this.resetButton = (ExtendedButton)this.m_142416_((GuiEventListener)new ExtendedButtonWithTooltip((this.f_96543_ - this.f_97726_) / 2 + 120, (this.f_96544_ - this.f_97727_) / 2 + 10, 50, 12, (Component)LocalizationKeys.MANAGER_GUI_RESET_BUTTON.getComponent(), button -> this.onResetButtonClicked(), this.buildTooltip(LocalizationKeys.MANAGER_GUI_RESET_BUTTON_TOOLTIP)));
        this.diagButton = (ExtendedButton)this.m_142416_((GuiEventListener)new ExtendedButtonWithTooltip((this.f_96543_ - this.f_97726_) / 2 + 35, (this.f_96544_ - this.f_97727_) / 2 + 48, 12, 14, (Component)Component.m_237113_((String)"!"), button -> this.onDiagButtonClicked(), this.buildTooltip(this.isReadOnly() ? LocalizationKeys.MANAGER_GUI_WARNING_BUTTON_TOOLTIP_READ_ONLY : LocalizationKeys.MANAGER_GUI_WARNING_BUTTON_TOOLTIP)));
        this.updateVisibilities();
    }

    private void onDiagButtonClicked() {
        if (Screen.m_96638_() && !this.isReadOnly()) {
            this.sendAttemptFix();
        } else {
            this.onSaveDiagClipboard();
        }
    }

    private void onEditButtonClicked() {
        ClientStuff.showProgramEditScreen(DiskItem.getProgram(((ManagerContainerMenu)this.f_97732_).getDisk()), this::sendProgram);
    }

    private void onExamplesButtonClicked() {
        ClientStuff.showExampleListScreen(DiskItem.getProgram(((ManagerContainerMenu)this.f_97732_).getDisk()), this::sendProgram);
    }

    private void onLogsButtonClicked() {
        ClientStuff.showLogsScreen((ManagerContainerMenu)this.f_97732_);
    }

    private void onResetButtonClicked() {
        ConfirmScreen confirmScreen = new ConfirmScreen(proceed -> {
            assert (this.f_96541_ != null);
            this.f_96541_.popGuiLayer();
            if (proceed) {
                SFMPackets.MANAGER_CHANNEL.sendToServer((Object)new ServerboundManagerResetPacket(((ManagerContainerMenu)this.f_97732_).f_38840_, ((ManagerContainerMenu)this.f_97732_).MANAGER_POSITION));
                this.status = LocalizationKeys.MANAGER_GUI_STATUS_RESET.getComponent();
                this.statusCountdown = 40.0f;
            }
        }, (Component)LocalizationKeys.MANAGER_RESET_CONFIRM_SCREEN_TITLE.getComponent(), (Component)LocalizationKeys.MANAGER_RESET_CONFIRM_SCREEN_MESSAGE.getComponent(), (Component)LocalizationKeys.MANAGER_RESET_CONFIRM_SCREEN_YES_BUTTON.getComponent(), (Component)LocalizationKeys.MANAGER_RESET_CONFIRM_SCREEN_NO_BUTTON.getComponent());
        assert (this.f_96541_ != null);
        this.f_96541_.pushGuiLayer((Screen)confirmScreen);
        confirmScreen.m_95663_(20);
    }

    private void onRebuildButtonClicked() {
        SFMPackets.MANAGER_CHANNEL.sendToServer((Object)new ServerboundManagerRebuildPacket(((ManagerContainerMenu)this.f_97732_).f_38840_, ((ManagerContainerMenu)this.f_97732_).MANAGER_POSITION));
        this.status = LocalizationKeys.MANAGER_GUI_STATUS_REBUILD.getComponent();
        this.statusCountdown = 40.0f;
    }

    private void sendAttemptFix() {
        SFMPackets.MANAGER_CHANNEL.sendToServer((Object)new ServerboundManagerFixPacket(((ManagerContainerMenu)this.f_97732_).f_38840_, ((ManagerContainerMenu)this.f_97732_).MANAGER_POSITION));
        this.status = LocalizationKeys.MANAGER_GUI_STATUS_FIX.getComponent();
        this.statusCountdown = 40.0f;
    }

    private void sendProgram(String program) {
        SFMPackets.MANAGER_CHANNEL.sendToServer((Object)new ServerboundManagerProgramPacket(((ManagerContainerMenu)this.f_97732_).f_38840_, ((ManagerContainerMenu)this.f_97732_).MANAGER_POSITION, program));
        ((ManagerContainerMenu)this.f_97732_).program = program;
        this.status = LocalizationKeys.MANAGER_GUI_STATUS_LOADED_CLIPBOARD.getComponent();
        this.statusCountdown = 40.0f;
    }

    private void onClipboardCopyButtonClicked() {
        try {
            Minecraft.m_91087_().f_91068_.m_90911_(((ManagerContainerMenu)this.f_97732_).program);
            this.status = LocalizationKeys.MANAGER_GUI_STATUS_SAVED_CLIPBOARD.getComponent();
            this.statusCountdown = 40.0f;
        }
        catch (Throwable t) {
            SFM.LOGGER.error("failed to save clipboard", t);
        }
    }

    private boolean shouldShowDiagButton() {
        ItemStack disk = ((ManagerContainerMenu)this.f_97732_).getDisk();
        if (!(disk.m_41720_() instanceof DiskItem)) {
            return false;
        }
        List<TranslatableContents> errors = DiskItem.getErrors(disk);
        List<TranslatableContents> warnings = DiskItem.getWarnings(disk);
        return !errors.isEmpty() || !warnings.isEmpty();
    }

    private void onSaveDiagClipboard() {
        try {
            ItemStack disk = ((ManagerContainerMenu)this.f_97732_).CONTAINER.m_8020_(0);
            if (!(disk.m_41720_() instanceof DiskItem)) {
                return;
            }
            String diagnosticInfo = ClientDiagnosticInfo.getDiagnosticInfo(((ManagerContainerMenu)this.f_97732_).program, disk);
            Minecraft.m_91087_().f_91068_.m_90911_(diagnosticInfo);
            this.status = LocalizationKeys.MANAGER_GUI_STATUS_SAVED_CLIPBOARD.getComponent();
            this.statusCountdown = 40.0f;
        }
        catch (Throwable t) {
            SFM.LOGGER.error("failed saving clipboard", t);
        }
    }

    private void onClipboardPasteButtonClicked() {
        try {
            String contents = Minecraft.m_91087_().f_91068_.m_90876_();
            this.sendProgram(contents);
        }
        catch (Throwable t) {
            SFM.LOGGER.error("failed loading clipboard", t);
        }
    }

    protected void m_280003_(GuiGraphics graphics, int mx, int my) {
        PoseStack poseStack = graphics.m_280168_();
        super.m_280003_(graphics, mx, my);
        ManagerBlockEntity.State state = ((ManagerContainerMenu)this.f_97732_).state;
        graphics.m_280614_(this.f_96547_, (Component)LocalizationKeys.MANAGER_GUI_STATE.getComponent(state.LOC.getComponent().m_130940_(state.COLOR)).m_130944_(new ChatFormatting[0]), this.f_97728_, 20, 0, false);
        if (!((ManagerContainerMenu)this.f_97732_).logLevel.equals(Level.OFF.name())) {
            poseStack.m_85836_();
            double d = this.f_97728_;
            Objects.requireNonNull(this.f_96547_);
            poseStack.m_85837_(d, 9.0 * 1.5, 0.0);
            poseStack.m_85841_(0.5f, 0.5f, 1.0f);
            graphics.m_280614_(this.f_96547_, (Component)Component.m_237113_((String)((ManagerContainerMenu)this.f_97732_).logLevel), 0, 0, 0, false);
            poseStack.m_85849_();
        }
        if (this.statusCountdown > 0.0f) {
            graphics.m_280614_(this.f_96547_, this.status, this.f_97730_ + this.f_96547_.m_92895_(this.f_169604_.getString()) + 5, this.f_97731_, 0, false);
        }
        long peakTickTimeNanoseconds = 0L;
        for (int i = 0; i < ((ManagerContainerMenu)this.f_97732_).tickTimeNanos.length; ++i) {
            peakTickTimeNanoseconds = Long.max(peakTickTimeNanoseconds, ((ManagerContainerMenu)this.f_97732_).tickTimeNanos[i]);
        }
        long yMax = Long.max(peakTickTimeNanoseconds, 50000000L);
        int plotX = this.f_97728_ + 45;
        int plotY = 40;
        int spaceBetweenPoints = 6;
        int plotWidth = 6 * (((ManagerContainerMenu)this.f_97732_).tickTimeNanos.length - 1);
        int plotHeight = 30;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        Tesselator tesselator = Tesselator.m_85913_();
        Matrix4f pose = graphics.m_280168_().m_85850_().m_252922_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.f_85815_);
        bufferbuilder.m_252986_(pose, (float)plotX, 40.0f, 0.0f).m_85950_(0.0f, 0.0f, 0.0f, 0.5f).m_5752_();
        bufferbuilder.m_252986_(pose, (float)(plotX + plotWidth), 40.0f, 0.0f).m_85950_(0.0f, 0.0f, 0.0f, 0.5f).m_5752_();
        bufferbuilder.m_252986_(pose, (float)(plotX + plotWidth), 70.0f, 0.0f).m_85950_(0.0f, 0.0f, 0.0f, 0.5f).m_5752_();
        bufferbuilder.m_252986_(pose, (float)plotX, 70.0f, 0.0f).m_85950_(0.0f, 0.0f, 0.0f, 0.5f).m_5752_();
        bufferbuilder.m_252986_(pose, (float)plotX, 40.0f, 0.0f).m_85950_(0.0f, 0.0f, 0.0f, 0.5f).m_5752_();
        tesselator.m_85914_();
        bufferbuilder = tesselator.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.f_85815_);
        int mouseTickTimeIndex = -1;
        for (int i = 0; i < ((ManagerContainerMenu)this.f_97732_).tickTimeNanos.length; ++i) {
            long y = ((ManagerContainerMenu)this.f_97732_).tickTimeNanos[i];
            float normalizedTickTime = y == 0L ? 0.0f : (float)(Math.log10(y) / Math.log10(yMax));
            int plotPosY = 70 - (int)(normalizedTickTime * 30.0f);
            int plotPosX = plotX + 6 * i;
            ChatFormatting c = this.getMillisecondColour((float)y / 1000000.0f);
            float red = (float)(c.m_126665_() >> 16 & 0xFF) / 255.0f;
            float green = (float)(c.m_126665_() >> 8 & 0xFF) / 255.0f;
            float blue = (float)(c.m_126665_() & 0xFF) / 255.0f;
            bufferbuilder.m_252986_(pose, (float)plotPosX, (float)plotPosY, 0.0f).m_85950_(red, green, blue, 1.0f).m_5752_();
            if (mx - this.f_97735_ < plotPosX - 3 || mx - this.f_97735_ > plotPosX + 3 || my - this.f_97736_ < 38 || my - this.f_97736_ > 72) continue;
            mouseTickTimeIndex = i;
        }
        tesselator.m_85914_();
        DecimalFormat format = new DecimalFormat("0.000");
        if (mouseTickTimeIndex != -1) {
            long hoveredTickTimeNanoseconds = ((ManagerContainerMenu)this.f_97732_).tickTimeNanos[mouseTickTimeIndex];
            float hoveredTickTimeMilliseconds = (float)hoveredTickTimeNanoseconds / 1000000.0f;
            String formattedMillis = format.format(hoveredTickTimeMilliseconds);
            ChatFormatting lagColor = this.getMillisecondColour(hoveredTickTimeMilliseconds);
            MutableComponent milliseconds = Component.m_237113_((String)formattedMillis).m_130940_(lagColor);
            MutableComponent mutableComponent = LocalizationKeys.MANAGER_GUI_HOVERED_TICK_TIME_MS.getComponent(milliseconds);
            Objects.requireNonNull(this.f_96547_);
            graphics.m_280614_(this.f_96547_, (Component)mutableComponent, this.f_97728_, 20 + 9, 0, false);
            RenderSystem.setShader(GameRenderer::m_172811_);
            tesselator = Tesselator.m_85913_();
            bufferbuilder = tesselator.m_85915_();
            bufferbuilder.m_166779_(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.f_85815_);
            pose = graphics.m_280168_().m_85850_().m_252922_();
            int x = plotX + 6 * mouseTickTimeIndex;
            bufferbuilder.m_252986_(pose, (float)x, 40.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
            bufferbuilder.m_252986_(pose, (float)x, 70.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
            tesselator.m_85914_();
        } else {
            float peakTickTimeMilliseconds = (float)peakTickTimeNanoseconds / 1000000.0f;
            String formattedMillis = format.format(peakTickTimeMilliseconds);
            ChatFormatting lagColor = this.getMillisecondColour(peakTickTimeMilliseconds);
            MutableComponent milliseconds = Component.m_237113_((String)formattedMillis).m_130940_(lagColor);
            MutableComponent mutableComponent = LocalizationKeys.MANAGER_GUI_PEAK_TICK_TIME_MS.getComponent(milliseconds);
            Objects.requireNonNull(this.f_96547_);
            graphics.m_280614_(this.f_96547_, (Component)mutableComponent, this.f_97728_, 20 + 9, 0, false);
        }
        RenderSystem.disableBlend();
    }

    protected void m_280072_(GuiGraphics pGuiGraphics, int pX, int pY) {
        if (Minecraft.m_91087_().f_91080_ != this) {
            this.f_169369_.stream().filter(AbstractWidget.class::isInstance).map(AbstractWidget.class::cast).forEach(w -> w.m_93692_(false));
            return;
        }
        super.m_280072_(pGuiGraphics, pX, pY);
    }

    protected void m_7286_(GuiGraphics graphics, float partialTicks, int mx, int my) {
        if (!((ManagerContainerMenu)this.f_97732_).logLevel.equals(Level.OFF.name())) {
            RenderSystem.setShaderColor((float)0.2f, (float)0.8f, (float)1.0f, (float)1.0f);
        } else {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        graphics.m_280218_(BACKGROUND_TEXTURE_LOCATION, i, j, 0, 0, this.f_97726_, this.f_97727_);
    }
}

