/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.integration.top;

import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.IElementFactory;
import me.desht.modularrouters.integration.top.TOPCompatibility;
import me.desht.modularrouters.item.module.ModuleItem;
import me.desht.modularrouters.util.ModuleHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.Validate;

public class ElementModule
implements IElement {
    private final ItemStack stack;
    private final ModuleItem.RelativeDirection dir;

    public ElementModule(ItemStack stack) {
        Validate.isTrue((boolean)(stack.m_41720_() instanceof ModuleItem), (String)"provided item stack is not an ItemModule!", (Object[])new Object[0]);
        this.stack = stack;
        this.dir = ModuleHelper.getRelativeDirection(stack);
    }

    public ElementModule(FriendlyByteBuf buf) {
        this.stack = buf.m_130267_();
        this.dir = (ModuleItem.RelativeDirection)buf.m_130066_(ModuleItem.RelativeDirection.class);
    }

    public void render(GuiGraphics graphics, int x, int y) {
        graphics.m_280480_(this.stack, x + (this.getWidth() - 18) / 2, y + (this.getHeight() - 18) / 2);
        graphics.m_280302_(Minecraft.m_91087_().f_91062_, this.stack, x + (this.getWidth() - 18) / 2, y + (this.getHeight() - 18) / 2, this.dir.getSymbol());
    }

    public int getWidth() {
        return 20;
    }

    public int getHeight() {
        return 20;
    }

    public void toBytes(FriendlyByteBuf buffer) {
        buffer.m_130055_(this.stack);
        buffer.m_130068_((Enum)this.dir);
    }

    public ResourceLocation getID() {
        return TOPCompatibility.ELEMENT_MODULE_ITEM;
    }

    public static class Factory
    implements IElementFactory {
        public IElement createElement(FriendlyByteBuf buf) {
            return new ElementModule(buf);
        }

        public ResourceLocation getId() {
            return TOPCompatibility.ELEMENT_MODULE_ITEM;
        }
    }
}

