/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.systems;

import com.google.common.collect.Queues;
import com.mojang.blaze3d.DontObfuscate;
import com.mojang.blaze3d.pipeline.RenderCall;
import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.IntConsumer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Locale;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.TimeSource;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallbackI;
import org.slf4j.Logger;

@DontObfuscate
public class RenderSystem {
    static final Logger LOGGER = LogUtils.getLogger();
    private static final ConcurrentLinkedQueue<RenderCall> recordingQueue = Queues.newConcurrentLinkedQueue();
    private static final Tesselator RENDER_THREAD_TESSELATOR = new Tesselator();
    private static final int MINIMUM_ATLAS_TEXTURE_SIZE = 1024;
    private static boolean isReplayingQueue;
    @Nullable
    private static Thread gameThread;
    @Nullable
    private static Thread renderThread;
    private static int MAX_SUPPORTED_TEXTURE_SIZE;
    private static boolean isInInit;
    private static double lastDrawTime;
    private static final AutoStorageIndexBuffer sharedSequential;
    private static final AutoStorageIndexBuffer sharedSequentialQuad;
    private static final AutoStorageIndexBuffer sharedSequentialLines;
    private static Matrix3f inverseViewRotationMatrix;
    private static Matrix4f projectionMatrix;
    private static Matrix4f savedProjectionMatrix;
    private static VertexSorting vertexSorting;
    private static VertexSorting savedVertexSorting;
    private static final PoseStack modelViewStack;
    private static Matrix4f modelViewMatrix;
    private static Matrix4f textureMatrix;
    private static final int[] shaderTextures;
    private static final float[] shaderColor;
    private static float shaderGlintAlpha;
    private static float shaderFogStart;
    private static float shaderFogEnd;
    private static final float[] shaderFogColor;
    private static FogShape shaderFogShape;
    private static final Vector3f[] shaderLightDirections;
    private static float shaderGameTime;
    private static float shaderLineWidth;
    private static String apiDescription;
    @Nullable
    private static ShaderInstance shader;
    private static final AtomicLong pollEventsWaitStart;
    private static final AtomicBoolean pollingEvents;

    public static void initRenderThread() {
        if (renderThread != null || gameThread == Thread.currentThread()) {
            throw new IllegalStateException("Could not initialize render thread");
        }
        renderThread = Thread.currentThread();
    }

    public static boolean isOnRenderThread() {
        return Thread.currentThread() == renderThread;
    }

    public static boolean isOnRenderThreadOrInit() {
        return isInInit || RenderSystem.isOnRenderThread();
    }

    public static void initGameThread(boolean p_69578_) {
        boolean $$1;
        boolean bl = $$1 = renderThread == Thread.currentThread();
        if (gameThread != null || renderThread == null || $$1 == p_69578_) {
            throw new IllegalStateException("Could not initialize tick thread");
        }
        gameThread = Thread.currentThread();
    }

    public static boolean isOnGameThread() {
        return true;
    }

    public static void assertInInitPhase() {
        if (!RenderSystem.isInInitPhase()) {
            throw RenderSystem.constructThreadException();
        }
    }

    public static void assertOnGameThreadOrInit() {
        if (isInInit || RenderSystem.isOnGameThread()) {
            return;
        }
        throw RenderSystem.constructThreadException();
    }

    public static void assertOnRenderThreadOrInit() {
        if (isInInit || RenderSystem.isOnRenderThread()) {
            return;
        }
        throw RenderSystem.constructThreadException();
    }

    public static void assertOnRenderThread() {
        if (!RenderSystem.isOnRenderThread()) {
            throw RenderSystem.constructThreadException();
        }
    }

    public static void assertOnGameThread() {
        if (!RenderSystem.isOnGameThread()) {
            throw RenderSystem.constructThreadException();
        }
    }

    private static IllegalStateException constructThreadException() {
        return new IllegalStateException("Rendersystem called from wrong thread");
    }

    public static boolean isInInitPhase() {
        return true;
    }

    public static void recordRenderCall(RenderCall p_69880_) {
        recordingQueue.add(p_69880_);
    }

    private static void pollEvents() {
        pollEventsWaitStart.set(Util.m_137550_());
        pollingEvents.set(true);
        GLFW.glfwPollEvents();
        pollingEvents.set(false);
    }

    public static boolean isFrozenAtPollEvents() {
        return pollingEvents.get() && Util.m_137550_() - pollEventsWaitStart.get() > 200L;
    }

    public static void flipFrame(long p_69496_) {
        RenderSystem.pollEvents();
        RenderSystem.replayQueue();
        Tesselator.m_85913_().m_85915_().m_85729_();
        GLFW.glfwSwapBuffers((long)p_69496_);
        RenderSystem.pollEvents();
    }

    public static void replayQueue() {
        isReplayingQueue = true;
        while (!recordingQueue.isEmpty()) {
            RenderCall $$0 = recordingQueue.poll();
            $$0.m_83909_();
        }
        isReplayingQueue = false;
    }

    public static void limitDisplayFPS(int p_69831_) {
        double $$1 = lastDrawTime + 1.0 / (double)p_69831_;
        double $$2 = GLFW.glfwGetTime();
        while ($$2 < $$1) {
            GLFW.glfwWaitEventsTimeout((double)($$1 - $$2));
            $$2 = GLFW.glfwGetTime();
        }
        lastDrawTime = $$2;
    }

    public static void disableDepthTest() {
        RenderSystem.assertOnRenderThread();
        GlStateManager._disableDepthTest();
    }

    public static void enableDepthTest() {
        RenderSystem.assertOnGameThreadOrInit();
        GlStateManager._enableDepthTest();
    }

    public static void enableScissor(int p_69489_, int p_69490_, int p_69491_, int p_69492_) {
        RenderSystem.assertOnGameThreadOrInit();
        GlStateManager._enableScissorTest();
        GlStateManager._scissorBox(p_69489_, p_69490_, p_69491_, p_69492_);
    }

    public static void disableScissor() {
        RenderSystem.assertOnGameThreadOrInit();
        GlStateManager._disableScissorTest();
    }

    public static void depthFunc(int p_69457_) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._depthFunc(p_69457_);
    }

    public static void depthMask(boolean p_69459_) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._depthMask(p_69459_);
    }

    public static void enableBlend() {
        RenderSystem.assertOnRenderThread();
        GlStateManager._enableBlend();
    }

    public static void disableBlend() {
        RenderSystem.assertOnRenderThread();
        GlStateManager._disableBlend();
    }

    public static void blendFunc(GlStateManager.SourceFactor p_69409_, GlStateManager.DestFactor p_69410_) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._blendFunc(p_69409_.value, p_69410_.value);
    }

    public static void blendFunc(int p_69406_, int p_69407_) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._blendFunc(p_69406_, p_69407_);
    }

    public static void blendFuncSeparate(GlStateManager.SourceFactor p_69417_, GlStateManager.DestFactor p_69418_, GlStateManager.SourceFactor p_69419_, GlStateManager.DestFactor p_69420_) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._blendFuncSeparate(p_69417_.value, p_69418_.value, p_69419_.value, p_69420_.value);
    }

    public static void blendFuncSeparate(int p_69412_, int p_69413_, int p_69414_, int p_69415_) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._blendFuncSeparate(p_69412_, p_69413_, p_69414_, p_69415_);
    }

    public static void blendEquation(int p_69404_) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._blendEquation(p_69404_);
    }

    public static void enableCull() {
        RenderSystem.assertOnRenderThread();
        GlStateManager._enableCull();
    }

    public static void disableCull() {
        RenderSystem.assertOnRenderThread();
        GlStateManager._disableCull();
    }

    public static void polygonMode(int p_69861_, int p_69862_) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._polygonMode(p_69861_, p_69862_);
    }

    public static void enablePolygonOffset() {
        RenderSystem.assertOnRenderThread();
        GlStateManager._enablePolygonOffset();
    }

    public static void disablePolygonOffset() {
        RenderSystem.assertOnRenderThread();
        GlStateManager._disablePolygonOffset();
    }

    public static void polygonOffset(float p_69864_, float p_69865_) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._polygonOffset(p_69864_, p_69865_);
    }

    public static void enableColorLogicOp() {
        RenderSystem.assertOnRenderThread();
        GlStateManager._enableColorLogicOp();
    }

    public static void disableColorLogicOp() {
        RenderSystem.assertOnRenderThread();
        GlStateManager._disableColorLogicOp();
    }

    public static void logicOp(GlStateManager.LogicOp p_69836_) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._logicOp(p_69836_.f_84715_);
    }

    public static void activeTexture(int p_69389_) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._activeTexture(p_69389_);
    }

    public static void texParameter(int p_69938_, int p_69939_, int p_69940_) {
        GlStateManager._texParameter(p_69938_, p_69939_, p_69940_);
    }

    public static void deleteTexture(int p_69455_) {
        RenderSystem.assertOnGameThreadOrInit();
        GlStateManager._deleteTexture(p_69455_);
    }

    public static void bindTextureForSetup(int p_157185_) {
        RenderSystem.bindTexture(p_157185_);
    }

    public static void bindTexture(int p_69397_) {
        GlStateManager._bindTexture(p_69397_);
    }

    public static void viewport(int p_69950_, int p_69951_, int p_69952_, int p_69953_) {
        RenderSystem.assertOnGameThreadOrInit();
        GlStateManager._viewport(p_69950_, p_69951_, p_69952_, p_69953_);
    }

    public static void colorMask(boolean p_69445_, boolean p_69446_, boolean p_69447_, boolean p_69448_) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._colorMask(p_69445_, p_69446_, p_69447_, p_69448_);
    }

    public static void stencilFunc(int p_69926_, int p_69927_, int p_69928_) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._stencilFunc(p_69926_, p_69927_, p_69928_);
    }

    public static void stencilMask(int p_69930_) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._stencilMask(p_69930_);
    }

    public static void stencilOp(int p_69932_, int p_69933_, int p_69934_) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._stencilOp(p_69932_, p_69933_, p_69934_);
    }

    public static void clearDepth(double p_69431_) {
        RenderSystem.assertOnGameThreadOrInit();
        GlStateManager._clearDepth(p_69431_);
    }

    public static void clearColor(float p_69425_, float p_69426_, float p_69427_, float p_69428_) {
        RenderSystem.assertOnGameThreadOrInit();
        GlStateManager._clearColor(p_69425_, p_69426_, p_69427_, p_69428_);
    }

    public static void clearStencil(int p_69433_) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._clearStencil(p_69433_);
    }

    public static void clear(int p_69422_, boolean p_69423_) {
        RenderSystem.assertOnGameThreadOrInit();
        GlStateManager._clear(p_69422_, p_69423_);
    }

    public static void setShaderFogStart(float p_157446_) {
        RenderSystem.assertOnRenderThread();
        RenderSystem._setShaderFogStart(p_157446_);
    }

    private static void _setShaderFogStart(float p_157172_) {
        shaderFogStart = p_157172_;
    }

    public static float getShaderFogStart() {
        RenderSystem.assertOnRenderThread();
        return shaderFogStart;
    }

    public static void setShaderGlintAlpha(double p_268332_) {
        RenderSystem.setShaderGlintAlpha((float)p_268332_);
    }

    public static void setShaderGlintAlpha(float p_268329_) {
        RenderSystem.assertOnRenderThread();
        RenderSystem._setShaderGlintAlpha(p_268329_);
    }

    private static void _setShaderGlintAlpha(float p_268319_) {
        shaderGlintAlpha = p_268319_;
    }

    public static float getShaderGlintAlpha() {
        RenderSystem.assertOnRenderThread();
        return shaderGlintAlpha;
    }

    public static void setShaderFogEnd(float p_157444_) {
        RenderSystem.assertOnRenderThread();
        RenderSystem._setShaderFogEnd(p_157444_);
    }

    private static void _setShaderFogEnd(float p_157170_) {
        shaderFogEnd = p_157170_;
    }

    public static float getShaderFogEnd() {
        RenderSystem.assertOnRenderThread();
        return shaderFogEnd;
    }

    public static void setShaderFogColor(float p_157439_, float p_157440_, float p_157441_, float p_157442_) {
        RenderSystem.assertOnRenderThread();
        RenderSystem._setShaderFogColor(p_157439_, p_157440_, p_157441_, p_157442_);
    }

    public static void setShaderFogColor(float p_157435_, float p_157436_, float p_157437_) {
        RenderSystem.setShaderFogColor(p_157435_, p_157436_, p_157437_, 1.0f);
    }

    private static void _setShaderFogColor(float p_157165_, float p_157166_, float p_157167_, float p_157168_) {
        RenderSystem.shaderFogColor[0] = p_157165_;
        RenderSystem.shaderFogColor[1] = p_157166_;
        RenderSystem.shaderFogColor[2] = p_157167_;
        RenderSystem.shaderFogColor[3] = p_157168_;
    }

    public static float[] getShaderFogColor() {
        RenderSystem.assertOnRenderThread();
        return shaderFogColor;
    }

    public static void setShaderFogShape(FogShape p_202161_) {
        RenderSystem.assertOnRenderThread();
        RenderSystem._setShaderFogShape(p_202161_);
    }

    private static void _setShaderFogShape(FogShape p_202040_) {
        shaderFogShape = p_202040_;
    }

    public static FogShape getShaderFogShape() {
        RenderSystem.assertOnRenderThread();
        return shaderFogShape;
    }

    public static void setShaderLights(Vector3f p_254155_, Vector3f p_254006_) {
        RenderSystem.assertOnRenderThread();
        RenderSystem._setShaderLights(p_254155_, p_254006_);
    }

    public static void _setShaderLights(Vector3f p_253618_, Vector3f p_253929_) {
        RenderSystem.shaderLightDirections[0] = p_253618_;
        RenderSystem.shaderLightDirections[1] = p_253929_;
    }

    public static void setupShaderLights(ShaderInstance p_157462_) {
        RenderSystem.assertOnRenderThread();
        if (p_157462_.f_173313_ != null) {
            p_157462_.f_173313_.m_142276_(shaderLightDirections[0]);
        }
        if (p_157462_.f_173314_ != null) {
            p_157462_.f_173314_.m_142276_(shaderLightDirections[1]);
        }
    }

    public static void setShaderColor(float p_157430_, float p_157431_, float p_157432_, float p_157433_) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> RenderSystem._setShaderColor(p_157430_, p_157431_, p_157432_, p_157433_));
        } else {
            RenderSystem._setShaderColor(p_157430_, p_157431_, p_157432_, p_157433_);
        }
    }

    private static void _setShaderColor(float p_157160_, float p_157161_, float p_157162_, float p_157163_) {
        RenderSystem.shaderColor[0] = p_157160_;
        RenderSystem.shaderColor[1] = p_157161_;
        RenderSystem.shaderColor[2] = p_157162_;
        RenderSystem.shaderColor[3] = p_157163_;
    }

    public static float[] getShaderColor() {
        RenderSystem.assertOnRenderThread();
        return shaderColor;
    }

    public static void drawElements(int p_157187_, int p_157188_, int p_157189_) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._drawElements(p_157187_, p_157188_, p_157189_, 0L);
    }

    public static void lineWidth(float p_69833_) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> {
                shaderLineWidth = p_69833_;
            });
        } else {
            shaderLineWidth = p_69833_;
        }
    }

    public static float getShaderLineWidth() {
        RenderSystem.assertOnRenderThread();
        return shaderLineWidth;
    }

    public static void pixelStore(int p_69855_, int p_69856_) {
        RenderSystem.assertOnGameThreadOrInit();
        GlStateManager._pixelStore(p_69855_, p_69856_);
    }

    public static void readPixels(int p_69872_, int p_69873_, int p_69874_, int p_69875_, int p_69876_, int p_69877_, ByteBuffer p_69878_) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._readPixels(p_69872_, p_69873_, p_69874_, p_69875_, p_69876_, p_69877_, p_69878_);
    }

    public static void getString(int p_69520_, Consumer<String> p_69521_) {
        RenderSystem.assertOnRenderThread();
        p_69521_.accept(GlStateManager._getString(p_69520_));
    }

    public static String getBackendDescription() {
        RenderSystem.assertInInitPhase();
        return String.format(Locale.ROOT, "LWJGL version %s", GLX._getLWJGLVersion());
    }

    public static String getApiDescription() {
        return apiDescription;
    }

    public static TimeSource.NanoTimeSource initBackendSystem() {
        RenderSystem.assertInInitPhase();
        return GLX._initGlfw()::getAsLong;
    }

    public static void initRenderer(int p_69581_, boolean p_69582_) {
        RenderSystem.assertInInitPhase();
        GLX._init(p_69581_, p_69582_);
        apiDescription = GLX.getOpenGLVersionString();
    }

    public static void setErrorCallback(GLFWErrorCallbackI p_69901_) {
        RenderSystem.assertInInitPhase();
        GLX._setGlfwErrorCallback(p_69901_);
    }

    public static void renderCrosshair(int p_69882_) {
        RenderSystem.assertOnRenderThread();
        GLX._renderCrosshair(p_69882_, true, true, true);
    }

    public static String getCapsString() {
        RenderSystem.assertOnRenderThread();
        return "Using framebuffer using OpenGL 3.2";
    }

    public static void setupDefaultState(int p_69903_, int p_69904_, int p_69905_, int p_69906_) {
        RenderSystem.assertInInitPhase();
        GlStateManager._clearDepth(1.0);
        GlStateManager._enableDepthTest();
        GlStateManager._depthFunc(515);
        projectionMatrix.identity();
        savedProjectionMatrix.identity();
        modelViewMatrix.identity();
        textureMatrix.identity();
        GlStateManager._viewport(p_69903_, p_69904_, p_69905_, p_69906_);
    }

    public static int maxSupportedTextureSize() {
        if (MAX_SUPPORTED_TEXTURE_SIZE == -1) {
            RenderSystem.assertOnRenderThreadOrInit();
            int $$0 = GlStateManager._getInteger(3379);
            for (int $$1 = Math.max(32768, $$0); $$1 >= 1024; $$1 >>= 1) {
                GlStateManager._texImage2D(32868, 0, 6408, $$1, $$1, 0, 6408, 5121, null);
                int $$2 = GlStateManager._getTexLevelParameter(32868, 0, 4096);
                if ($$2 == 0) continue;
                MAX_SUPPORTED_TEXTURE_SIZE = $$1;
                return $$1;
            }
            MAX_SUPPORTED_TEXTURE_SIZE = Math.max($$0, 1024);
            LOGGER.info("Failed to determine maximum texture size by probing, trying GL_MAX_TEXTURE_SIZE = {}", (Object)MAX_SUPPORTED_TEXTURE_SIZE);
        }
        return MAX_SUPPORTED_TEXTURE_SIZE;
    }

    public static void glBindBuffer(int p_157209_, IntSupplier p_157210_) {
        GlStateManager._glBindBuffer(p_157209_, p_157210_.getAsInt());
    }

    public static void glBindVertexArray(Supplier<Integer> p_157212_) {
        GlStateManager._glBindVertexArray(p_157212_.get());
    }

    public static void glBufferData(int p_69526_, ByteBuffer p_69527_, int p_69528_) {
        RenderSystem.assertOnRenderThreadOrInit();
        GlStateManager._glBufferData(p_69526_, p_69527_, p_69528_);
    }

    public static void glDeleteBuffers(int p_69530_) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._glDeleteBuffers(p_69530_);
    }

    public static void glDeleteVertexArrays(int p_157214_) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._glDeleteVertexArrays(p_157214_);
    }

    public static void glUniform1i(int p_69544_, int p_69545_) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._glUniform1i(p_69544_, p_69545_);
    }

    public static void glUniform1(int p_69541_, IntBuffer p_69542_) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._glUniform1(p_69541_, p_69542_);
    }

    public static void glUniform2(int p_69550_, IntBuffer p_69551_) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._glUniform2(p_69550_, p_69551_);
    }

    public static void glUniform3(int p_69556_, IntBuffer p_69557_) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._glUniform3(p_69556_, p_69557_);
    }

    public static void glUniform4(int p_69562_, IntBuffer p_69563_) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._glUniform4(p_69562_, p_69563_);
    }

    public static void glUniform1(int p_69538_, FloatBuffer p_69539_) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._glUniform1(p_69538_, p_69539_);
    }

    public static void glUniform2(int p_69547_, FloatBuffer p_69548_) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._glUniform2(p_69547_, p_69548_);
    }

    public static void glUniform3(int p_69553_, FloatBuffer p_69554_) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._glUniform3(p_69553_, p_69554_);
    }

    public static void glUniform4(int p_69559_, FloatBuffer p_69560_) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._glUniform4(p_69559_, p_69560_);
    }

    public static void glUniformMatrix2(int p_69565_, boolean p_69566_, FloatBuffer p_69567_) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._glUniformMatrix2(p_69565_, p_69566_, p_69567_);
    }

    public static void glUniformMatrix3(int p_69569_, boolean p_69570_, FloatBuffer p_69571_) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._glUniformMatrix3(p_69569_, p_69570_, p_69571_);
    }

    public static void glUniformMatrix4(int p_69573_, boolean p_69574_, FloatBuffer p_69575_) {
        RenderSystem.assertOnRenderThread();
        GlStateManager._glUniformMatrix4(p_69573_, p_69574_, p_69575_);
    }

    public static void setupOverlayColor(IntSupplier p_69921_, int p_69922_) {
        RenderSystem.assertOnRenderThread();
        int $$2 = p_69921_.getAsInt();
        RenderSystem.setShaderTexture(1, $$2);
    }

    public static void teardownOverlayColor() {
        RenderSystem.assertOnRenderThread();
        RenderSystem.setShaderTexture(1, 0);
    }

    public static void setupLevelDiffuseLighting(Vector3f p_254489_, Vector3f p_254541_, Matrix4f p_253812_) {
        RenderSystem.assertOnRenderThread();
        GlStateManager.setupLevelDiffuseLighting(p_254489_, p_254541_, p_253812_);
    }

    public static void setupGuiFlatDiffuseLighting(Vector3f p_254419_, Vector3f p_254483_) {
        RenderSystem.assertOnRenderThread();
        GlStateManager.setupGuiFlatDiffuseLighting(p_254419_, p_254483_);
    }

    public static void setupGui3DDiffuseLighting(Vector3f p_253859_, Vector3f p_253890_) {
        RenderSystem.assertOnRenderThread();
        GlStateManager.setupGui3DDiffuseLighting(p_253859_, p_253890_);
    }

    public static void beginInitialization() {
        isInInit = true;
    }

    public static void finishInitialization() {
        isInInit = false;
        if (!recordingQueue.isEmpty()) {
            RenderSystem.replayQueue();
        }
        if (!recordingQueue.isEmpty()) {
            throw new IllegalStateException("Recorded to render queue during initialization");
        }
    }

    public static void glGenBuffers(Consumer<Integer> p_69532_) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> p_69532_.accept(GlStateManager._glGenBuffers()));
        } else {
            p_69532_.accept(GlStateManager._glGenBuffers());
        }
    }

    public static void glGenVertexArrays(Consumer<Integer> p_157216_) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> p_157216_.accept(GlStateManager._glGenVertexArrays()));
        } else {
            p_157216_.accept(GlStateManager._glGenVertexArrays());
        }
    }

    public static Tesselator renderThreadTesselator() {
        RenderSystem.assertOnRenderThread();
        return RENDER_THREAD_TESSELATOR;
    }

    public static void defaultBlendFunc() {
        RenderSystem.blendFuncSeparate(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
    }

    @Deprecated
    public static void runAsFancy(Runnable p_69891_) {
        boolean $$1 = Minecraft.m_91085_();
        if (!$$1) {
            p_69891_.run();
            return;
        }
        OptionInstance<GraphicsStatus> $$2 = Minecraft.m_91087_().f_91066_.m_232060_();
        GraphicsStatus $$3 = $$2.m_231551_();
        $$2.m_231514_(GraphicsStatus.FANCY);
        p_69891_.run();
        $$2.m_231514_($$3);
    }

    public static void setShader(Supplier<ShaderInstance> p_157428_) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> {
                shader = (ShaderInstance)p_157428_.get();
            });
        } else {
            shader = p_157428_.get();
        }
    }

    @Nullable
    public static ShaderInstance getShader() {
        RenderSystem.assertOnRenderThread();
        return shader;
    }

    public static void setShaderTexture(int p_157457_, ResourceLocation p_157458_) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> RenderSystem._setShaderTexture(p_157457_, p_157458_));
        } else {
            RenderSystem._setShaderTexture(p_157457_, p_157458_);
        }
    }

    public static void _setShaderTexture(int p_157180_, ResourceLocation p_157181_) {
        if (p_157180_ >= 0 && p_157180_ < shaderTextures.length) {
            TextureManager $$2 = Minecraft.m_91087_().m_91097_();
            AbstractTexture $$3 = $$2.m_118506_(p_157181_);
            RenderSystem.shaderTextures[p_157180_] = $$3.m_117963_();
        }
    }

    public static void setShaderTexture(int p_157454_, int p_157455_) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> RenderSystem._setShaderTexture(p_157454_, p_157455_));
        } else {
            RenderSystem._setShaderTexture(p_157454_, p_157455_);
        }
    }

    public static void _setShaderTexture(int p_157177_, int p_157178_) {
        if (p_157177_ >= 0 && p_157177_ < shaderTextures.length) {
            RenderSystem.shaderTextures[p_157177_] = p_157178_;
        }
    }

    public static int getShaderTexture(int p_157204_) {
        RenderSystem.assertOnRenderThread();
        if (p_157204_ >= 0 && p_157204_ < shaderTextures.length) {
            return shaderTextures[p_157204_];
        }
        return 0;
    }

    public static void setProjectionMatrix(Matrix4f p_277884_, VertexSorting p_277702_) {
        Matrix4f $$2 = new Matrix4f((Matrix4fc)p_277884_);
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> {
                projectionMatrix = $$2;
                vertexSorting = p_277702_;
            });
        } else {
            projectionMatrix = $$2;
            vertexSorting = p_277702_;
        }
    }

    public static void setInverseViewRotationMatrix(Matrix3f p_253989_) {
        Matrix3f $$1 = new Matrix3f((Matrix3fc)p_253989_);
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> {
                inverseViewRotationMatrix = $$1;
            });
        } else {
            inverseViewRotationMatrix = $$1;
        }
    }

    public static void setTextureMatrix(Matrix4f p_254081_) {
        Matrix4f $$1 = new Matrix4f((Matrix4fc)p_254081_);
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> {
                textureMatrix = $$1;
            });
        } else {
            textureMatrix = $$1;
        }
    }

    public static void resetTextureMatrix() {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> textureMatrix.identity());
        } else {
            textureMatrix.identity();
        }
    }

    public static void applyModelViewMatrix() {
        Matrix4f $$0 = new Matrix4f((Matrix4fc)modelViewStack.m_85850_().m_252922_());
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> {
                modelViewMatrix = $$0;
            });
        } else {
            modelViewMatrix = $$0;
        }
    }

    public static void backupProjectionMatrix() {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> RenderSystem._backupProjectionMatrix());
        } else {
            RenderSystem._backupProjectionMatrix();
        }
    }

    private static void _backupProjectionMatrix() {
        savedProjectionMatrix = projectionMatrix;
        savedVertexSorting = vertexSorting;
    }

    public static void restoreProjectionMatrix() {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> RenderSystem._restoreProjectionMatrix());
        } else {
            RenderSystem._restoreProjectionMatrix();
        }
    }

    private static void _restoreProjectionMatrix() {
        projectionMatrix = savedProjectionMatrix;
        vertexSorting = savedVertexSorting;
    }

    public static Matrix4f getProjectionMatrix() {
        RenderSystem.assertOnRenderThread();
        return projectionMatrix;
    }

    public static Matrix3f getInverseViewRotationMatrix() {
        RenderSystem.assertOnRenderThread();
        return inverseViewRotationMatrix;
    }

    public static Matrix4f getModelViewMatrix() {
        RenderSystem.assertOnRenderThread();
        return modelViewMatrix;
    }

    public static PoseStack getModelViewStack() {
        return modelViewStack;
    }

    public static Matrix4f getTextureMatrix() {
        RenderSystem.assertOnRenderThread();
        return textureMatrix;
    }

    public static AutoStorageIndexBuffer getSequentialBuffer(VertexFormat.Mode p_221942_) {
        RenderSystem.assertOnRenderThread();
        return switch (p_221942_) {
            case VertexFormat.Mode.QUADS -> sharedSequentialQuad;
            case VertexFormat.Mode.LINES -> sharedSequentialLines;
            default -> sharedSequential;
        };
    }

    public static void setShaderGameTime(long p_157448_, float p_157449_) {
        float $$2 = ((float)(p_157448_ % 24000L) + p_157449_) / 24000.0f;
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> {
                shaderGameTime = $$2;
            });
        } else {
            shaderGameTime = $$2;
        }
    }

    public static float getShaderGameTime() {
        RenderSystem.assertOnRenderThread();
        return shaderGameTime;
    }

    public static VertexSorting getVertexSorting() {
        RenderSystem.assertOnRenderThread();
        return vertexSorting;
    }

    private static /* synthetic */ void lambda$setupGui3DDiffuseLighting$59(Vector3f p_253271_, Vector3f p_253272_) {
        GlStateManager.setupGui3DDiffuseLighting(p_253271_, p_253272_);
    }

    private static /* synthetic */ void lambda$setupGuiFlatDiffuseLighting$58(Vector3f p_253277_, Vector3f p_253278_) {
        GlStateManager.setupGuiFlatDiffuseLighting(p_253277_, p_253278_);
    }

    private static /* synthetic */ void lambda$setupLevelDiffuseLighting$57(Vector3f p_253267_, Vector3f p_253268_, Matrix4f p_253269_) {
        GlStateManager.setupLevelDiffuseLighting(p_253267_, p_253268_, p_253269_);
    }

    private static /* synthetic */ void lambda$teardownOverlayColor$56() {
        RenderSystem.setShaderTexture(1, 0);
    }

    private static /* synthetic */ void lambda$setupOverlayColor$55(IntSupplier p_202158_) {
        int $$1 = p_202158_.getAsInt();
        RenderSystem.setShaderTexture(1, $$1);
    }

    private static /* synthetic */ void lambda$glUniformMatrix4$54(int p_202101_, boolean p_202102_, FloatBuffer p_202103_) {
        GlStateManager._glUniformMatrix4(p_202101_, p_202102_, p_202103_);
    }

    private static /* synthetic */ void lambda$glUniformMatrix3$53(int p_202097_, boolean p_202098_, FloatBuffer p_202099_) {
        GlStateManager._glUniformMatrix3(p_202097_, p_202098_, p_202099_);
    }

    private static /* synthetic */ void lambda$glUniformMatrix2$52(int p_202093_, boolean p_202094_, FloatBuffer p_202095_) {
        GlStateManager._glUniformMatrix2(p_202093_, p_202094_, p_202095_);
    }

    private static /* synthetic */ void lambda$glUniform4$51(int p_202090_, FloatBuffer p_202091_) {
        GlStateManager._glUniform4(p_202090_, p_202091_);
    }

    private static /* synthetic */ void lambda$glUniform3$50(int p_202084_, FloatBuffer p_202085_) {
        GlStateManager._glUniform3(p_202084_, p_202085_);
    }

    private static /* synthetic */ void lambda$glUniform2$49(int p_202078_, FloatBuffer p_202079_) {
        GlStateManager._glUniform2(p_202078_, p_202079_);
    }

    private static /* synthetic */ void lambda$glUniform1$48(int p_202069_, FloatBuffer p_202070_) {
        GlStateManager._glUniform1(p_202069_, p_202070_);
    }

    private static /* synthetic */ void lambda$glUniform4$47(int p_202087_, IntBuffer p_202088_) {
        GlStateManager._glUniform4(p_202087_, p_202088_);
    }

    private static /* synthetic */ void lambda$glUniform3$46(int p_202081_, IntBuffer p_202082_) {
        GlStateManager._glUniform3(p_202081_, p_202082_);
    }

    private static /* synthetic */ void lambda$glUniform2$45(int p_202075_, IntBuffer p_202076_) {
        GlStateManager._glUniform2(p_202075_, p_202076_);
    }

    private static /* synthetic */ void lambda$glUniform1$44(int p_202066_, IntBuffer p_202067_) {
        GlStateManager._glUniform1(p_202066_, p_202067_);
    }

    private static /* synthetic */ void lambda$glUniform1i$43(int p_202072_, int p_202073_) {
        GlStateManager._glUniform1i(p_202072_, p_202073_);
    }

    private static /* synthetic */ void lambda$glDeleteVertexArrays$42(int p_202060_) {
        GlStateManager._glDeleteVertexArrays(p_202060_);
    }

    private static /* synthetic */ void lambda$glDeleteBuffers$41(int p_202058_) {
        GlStateManager._glDeleteBuffers(p_202058_);
    }

    private static /* synthetic */ void lambda$glBindVertexArray$40(Supplier p_202056_) {
        GlStateManager._glBindVertexArray((Integer)p_202056_.get());
    }

    private static /* synthetic */ void lambda$glBindBuffer$39(int p_202053_, IntSupplier p_202054_) {
        GlStateManager._glBindBuffer(p_202053_, p_202054_.getAsInt());
    }

    private static /* synthetic */ void lambda$renderCrosshair$38(int p_202118_) {
        GLX._renderCrosshair(p_202118_, true, true, true);
    }

    private static /* synthetic */ void lambda$getString$37(int p_202050_, Consumer p_202051_) {
        String $$2 = GlStateManager._getString(p_202050_);
        p_202051_.accept($$2);
    }

    private static /* synthetic */ void lambda$readPixels$36(int p_202110_, int p_202111_, int p_202112_, int p_202113_, int p_202114_, int p_202115_, ByteBuffer p_202116_) {
        GlStateManager._readPixels(p_202110_, p_202111_, p_202112_, p_202113_, p_202114_, p_202115_, p_202116_);
    }

    private static /* synthetic */ void lambda$pixelStore$35(int p_202107_, int p_202108_) {
        GlStateManager._pixelStore(p_202107_, p_202108_);
    }

    private static /* synthetic */ void lambda$drawElements$33(int p_202046_, int p_202047_, int p_202048_) {
        GlStateManager._drawElements(p_202046_, p_202047_, p_202048_, 0L);
    }

    private static /* synthetic */ void lambda$setShaderLights$31(Vector3f p_253275_, Vector3f p_253276_) {
        RenderSystem._setShaderLights(p_253275_, p_253276_);
    }

    private static /* synthetic */ void lambda$setShaderFogShape$30(FogShape p_202133_) {
        RenderSystem._setShaderFogShape(p_202133_);
    }

    private static /* synthetic */ void lambda$setShaderFogColor$29(float p_157364_, float p_157365_, float p_157366_, float p_157367_) {
        RenderSystem._setShaderFogColor(p_157364_, p_157365_, p_157366_, p_157367_);
    }

    private static /* synthetic */ void lambda$setShaderFogEnd$28(float p_157369_) {
        RenderSystem._setShaderFogEnd(p_157369_);
    }

    private static /* synthetic */ void lambda$setShaderGlintAlpha$27(float p_267834_) {
        RenderSystem._setShaderGlintAlpha(p_267834_);
    }

    private static /* synthetic */ void lambda$setShaderFogStart$26(float p_157371_) {
        RenderSystem._setShaderFogStart(p_157371_);
    }

    private static /* synthetic */ void lambda$clear$25(int p_157243_, boolean p_157244_) {
        GlStateManager._clear(p_157243_, p_157244_);
    }

    private static /* synthetic */ void lambda$clearStencil$24(int p_157253_) {
        GlStateManager._clearStencil(p_157253_);
    }

    private static /* synthetic */ void lambda$clearColor$23(float p_157246_, float p_157247_, float p_157248_, float p_157249_) {
        GlStateManager._clearColor(p_157246_, p_157247_, p_157248_, p_157249_);
    }

    private static /* synthetic */ void lambda$clearDepth$22(double p_157251_) {
        GlStateManager._clearDepth(p_157251_);
    }

    private static /* synthetic */ void lambda$stencilOp$21(int p_157410_, int p_157411_, int p_157412_) {
        GlStateManager._stencilOp(p_157410_, p_157411_, p_157412_);
    }

    private static /* synthetic */ void lambda$stencilMask$20(int p_157408_) {
        GlStateManager._stencilMask(p_157408_);
    }

    private static /* synthetic */ void lambda$stencilFunc$19(int p_157404_, int p_157405_, int p_157406_) {
        GlStateManager._stencilFunc(p_157404_, p_157405_, p_157406_);
    }

    private static /* synthetic */ void lambda$colorMask$18(boolean p_157255_, boolean p_157256_, boolean p_157257_, boolean p_157258_) {
        GlStateManager._colorMask(p_157255_, p_157256_, p_157257_, p_157258_);
    }

    private static /* synthetic */ void lambda$viewport$17(int p_157419_, int p_157420_, int p_157421_, int p_157422_) {
        GlStateManager._viewport(p_157419_, p_157420_, p_157421_, p_157422_);
    }

    private static /* synthetic */ void lambda$bindTexture$16(int p_157223_) {
        GlStateManager._bindTexture(p_157223_);
    }

    private static /* synthetic */ void lambda$deleteTexture$15(int p_157260_) {
        GlStateManager._deleteTexture(p_157260_);
    }

    private static /* synthetic */ void lambda$texParameter$14(int p_157415_, int p_157416_, int p_157417_) {
        GlStateManager._texParameter(p_157415_, p_157416_, p_157417_);
    }

    private static /* synthetic */ void lambda$activeTexture$13(int p_157218_) {
        GlStateManager._activeTexture(p_157218_);
    }

    private static /* synthetic */ void lambda$logicOp$12(GlStateManager.LogicOp p_157332_) {
        GlStateManager._logicOp(p_157332_.f_84715_);
    }

    private static /* synthetic */ void lambda$polygonOffset$11(float p_157340_, float p_157341_) {
        GlStateManager._polygonOffset(p_157340_, p_157341_);
    }

    private static /* synthetic */ void lambda$polygonMode$10(int p_157337_, int p_157338_) {
        GlStateManager._polygonMode(p_157337_, p_157338_);
    }

    private static /* synthetic */ void lambda$blendEquation$9(int p_157225_) {
        GlStateManager._blendEquation(p_157225_);
    }

    private static /* synthetic */ void lambda$blendFuncSeparate$8(int p_157238_, int p_157239_, int p_157240_, int p_157241_) {
        GlStateManager._blendFuncSeparate(p_157238_, p_157239_, p_157240_, p_157241_);
    }

    private static /* synthetic */ void lambda$blendFuncSeparate$7(GlStateManager.SourceFactor p_157233_, GlStateManager.DestFactor p_157234_, GlStateManager.SourceFactor p_157235_, GlStateManager.DestFactor p_157236_) {
        GlStateManager._blendFuncSeparate(p_157233_.value, p_157234_.value, p_157235_.value, p_157236_.value);
    }

    private static /* synthetic */ void lambda$blendFunc$6(int p_157230_, int p_157231_) {
        GlStateManager._blendFunc(p_157230_, p_157231_);
    }

    private static /* synthetic */ void lambda$blendFunc$5(GlStateManager.SourceFactor p_157227_, GlStateManager.DestFactor p_157228_) {
        GlStateManager._blendFunc(p_157227_.value, p_157228_.value);
    }

    private static /* synthetic */ void lambda$depthMask$4(boolean p_157264_) {
        GlStateManager._depthMask(p_157264_);
    }

    private static /* synthetic */ void lambda$depthFunc$3(int p_157262_) {
        GlStateManager._depthFunc(p_157262_);
    }

    private static /* synthetic */ void lambda$enableScissor$2(int p_157270_, int p_157271_, int p_157272_, int p_157273_) {
        GlStateManager._enableScissorTest();
        GlStateManager._scissorBox(p_157270_, p_157271_, p_157272_, p_157273_);
    }

    static {
        MAX_SUPPORTED_TEXTURE_SIZE = -1;
        lastDrawTime = Double.MIN_VALUE;
        sharedSequential = new AutoStorageIndexBuffer(1, 1, java.util.function.IntConsumer::accept);
        sharedSequentialQuad = new AutoStorageIndexBuffer(4, 6, (p_157398_, p_157399_) -> {
            p_157398_.accept(p_157399_ + 0);
            p_157398_.accept(p_157399_ + 1);
            p_157398_.accept(p_157399_ + 2);
            p_157398_.accept(p_157399_ + 2);
            p_157398_.accept(p_157399_ + 3);
            p_157398_.accept(p_157399_ + 0);
        });
        sharedSequentialLines = new AutoStorageIndexBuffer(4, 6, (p_157401_, p_157402_) -> {
            p_157401_.accept(p_157402_ + 0);
            p_157401_.accept(p_157402_ + 1);
            p_157401_.accept(p_157402_ + 2);
            p_157401_.accept(p_157402_ + 3);
            p_157401_.accept(p_157402_ + 2);
            p_157401_.accept(p_157402_ + 1);
        });
        inverseViewRotationMatrix = new Matrix3f().zero();
        projectionMatrix = new Matrix4f();
        savedProjectionMatrix = new Matrix4f();
        vertexSorting = VertexSorting.f_276450_;
        savedVertexSorting = VertexSorting.f_276450_;
        modelViewStack = new PoseStack();
        modelViewMatrix = new Matrix4f();
        textureMatrix = new Matrix4f();
        shaderTextures = new int[12];
        shaderColor = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        shaderGlintAlpha = 1.0f;
        shaderFogEnd = 1.0f;
        shaderFogColor = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        shaderFogShape = FogShape.SPHERE;
        shaderLightDirections = new Vector3f[2];
        shaderLineWidth = 1.0f;
        apiDescription = "Unknown";
        pollEventsWaitStart = new AtomicLong();
        pollingEvents = new AtomicBoolean(false);
    }

    public static final class AutoStorageIndexBuffer {
        private final int f_157465_;
        private final int f_157466_;
        private final IndexGenerator f_157467_;
        private int f_157468_;
        private VertexFormat.IndexType f_157469_ = VertexFormat.IndexType.SHORT;
        private int f_157470_;

        AutoStorageIndexBuffer(int p_157472_, int p_157473_, IndexGenerator p_157474_) {
            this.f_157465_ = p_157472_;
            this.f_157466_ = p_157473_;
            this.f_157467_ = p_157474_;
        }

        public boolean m_221944_(int p_221945_) {
            return p_221945_ <= this.f_157470_;
        }

        public void m_221946_(int p_221947_) {
            if (this.f_157468_ == 0) {
                this.f_157468_ = GlStateManager._glGenBuffers();
            }
            GlStateManager._glBindBuffer(34963, this.f_157468_);
            this.m_157476_(p_221947_);
        }

        private void m_157476_(int p_157477_) {
            if (this.m_221944_(p_157477_)) {
                return;
            }
            p_157477_ = Mth.m_144941_(p_157477_ * 2, this.f_157466_);
            LOGGER.debug("Growing IndexBuffer: Old limit {}, new limit {}.", (Object)this.f_157470_, (Object)p_157477_);
            VertexFormat.IndexType $$1 = VertexFormat.IndexType.m_166933_(p_157477_);
            int $$2 = Mth.m_144941_(p_157477_ * $$1.f_166924_, 4);
            GlStateManager._glBufferData(34963, $$2, 35048);
            ByteBuffer $$3 = GlStateManager._glMapBuffer(34963, 35001);
            if ($$3 == null) {
                throw new RuntimeException("Failed to map GL buffer");
            }
            this.f_157469_ = $$1;
            IntConsumer $$4 = this.m_157478_($$3);
            for (int $$5 = 0; $$5 < p_157477_; $$5 += this.f_157466_) {
                this.f_157467_.m_157487_($$4, $$5 * this.f_157465_ / this.f_157466_);
            }
            GlStateManager._glUnmapBuffer(34963);
            this.f_157470_ = p_157477_;
        }

        private IntConsumer m_157478_(ByteBuffer p_157479_) {
            switch (this.f_157469_) {
                case SHORT: {
                    return p_157482_ -> p_157479_.putShort((short)p_157482_);
                }
            }
            return p_157479_::putInt;
        }

        public VertexFormat.IndexType m_157483_() {
            return this.f_157469_;
        }

        static interface IndexGenerator {
            public void m_157487_(IntConsumer var1, int var2);
        }
    }
}

