/*
 * Decompiled with CFR 0.152.
 */
package cofh.redstonearsenal.common.entity;

import cofh.redstonearsenal.common.item.IFluxItem;
import cofh.redstonearsenal.init.registries.ModEntities;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class FluxArrow
extends AbstractArrow {
    protected static final EntityDataAccessor<Byte> RSA_FLAGS = SynchedEntityData.m_135353_(FluxArrow.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected static final int LIFESPAN = 200;
    protected static final float EXPLOSION_RANGE = 4.0f;

    public FluxArrow(EntityType<? extends FluxArrow> entityIn, Level worldIn) {
        super(entityIn, worldIn);
    }

    public FluxArrow(Level worldIn, LivingEntity shooter) {
        super((EntityType)ModEntities.FLUX_ARROW.get(), shooter, worldIn);
    }

    public FluxArrow(Level worldIn, double x, double y, double z) {
        super((EntityType)ModEntities.FLUX_ARROW.get(), x, y, z, worldIn);
    }

    protected ItemStack m_7941_() {
        return ItemStack.f_41583_;
    }

    public void setExplodeArrow(boolean explode) {
        this.setRSAFlag(1, explode);
    }

    public boolean isExplodeArrow() {
        return ((Byte)this.f_19804_.m_135370_(RSA_FLAGS) & 1) != 0;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(RSA_FLAGS, (Object)0);
    }

    private void setRSAFlag(int flag, boolean value) {
        byte b0 = (Byte)this.f_19804_.m_135370_(RSA_FLAGS);
        if (value) {
            this.f_19804_.m_135381_(RSA_FLAGS, (Object)((byte)(b0 | flag)));
        } else {
            this.f_19804_.m_135381_(RSA_FLAGS, (Object)((byte)(b0 & ~flag)));
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public DamageSource getDamageSource(AbstractArrow arrow, @Nullable Entity shooter) {
        return IFluxItem.fluxRangedDamage((Projectile)arrow, (Entity)(shooter == null ? arrow : shooter));
    }

    public void explode(Vec3 pos) {
        if (!this.f_19853_.m_5776_()) {
            ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123813_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
            this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11913_, SoundSource.BLOCKS, 0.5f, (1.0f + (this.f_19853_.f_46441_.m_188501_() - this.f_19853_.f_46441_.m_188501_()) * 0.2f) * 0.7f);
            double r2 = 16.0;
            AABB searchArea = this.m_20191_().m_82383_(pos.m_82546_(this.m_20182_())).m_82400_(4.0);
            for (Entity target : this.f_19853_.m_6249_((Entity)this, searchArea, EntitySelector.f_20406_)) {
                if (!(pos.m_82557_(target.m_20191_().m_82399_()) < r2)) continue;
                target.m_6469_(this.getDamageSource(this, this.m_19749_()), (float)this.m_36789_());
            }
            this.m_146870_();
        }
    }

    public void m_8119_() {
        if (!this.f_19853_.m_5776_() && this.f_19797_ > 200) {
            this.m_146870_();
        } else {
            super.m_8119_();
        }
    }

    public float getGravity() {
        return this.m_20068_() || this.f_19794_ ? 0.0f : 0.05f;
    }

    public byte m_36796_() {
        return this.isExplodeArrow() ? (byte)0 : super.m_36796_();
    }

    protected float m_6882_() {
        return 0.99f;
    }

    protected void m_6532_(HitResult result) {
        if (this.isExplodeArrow()) {
            this.explode(result.m_82450_());
        } else {
            HitResult.Type type = result.m_6662_();
            if (type == HitResult.Type.ENTITY) {
                this.m_5790_((EntityHitResult)result);
            } else if (type == HitResult.Type.BLOCK) {
                this.m_8060_((BlockHitResult)result);
            }
        }
    }

    protected void m_8060_(BlockHitResult result) {
        if (this.isExplodeArrow()) {
            this.explode(result.m_82450_());
            return;
        }
        this.f_19853_.m_7605_((Entity)this, (byte)3);
        this.m_146870_();
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128379_("explode", this.isExplodeArrow());
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setExplodeArrow(nbt.m_128471_("explode"));
    }
}

