/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.common.block;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SpongeBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class IndustrialInsulationBlock
extends SpongeBlock {
    private static final int MAX_REPLACES = 64;
    private static final int MAX_RANGE = 6;

    public IndustrialInsulationBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    private void removeBlock(BlockPos block, Level level) {
        level.m_7731_(block, Blocks.f_50016_.m_49966_(), 3);
    }

    protected void m_56797_(Level level, BlockPos pos) {
        LinkedList queue = Lists.newLinkedList();
        queue.add(new Tuple((Object)pos, (Object)0));
        int checkedBlocksCount = 0;
        while (!queue.isEmpty()) {
            Tuple tuple = (Tuple)queue.poll();
            BlockPos blockpos = (BlockPos)tuple.m_14418_();
            int currentRange = (Integer)tuple.m_14419_();
            for (Direction direction : Direction.values()) {
                BucketPickup bucketPickup;
                BlockPos blockToCheckPos = blockpos.m_121945_(direction);
                BlockState blockToCheckState = level.m_8055_(blockToCheckPos);
                Block blockToCheck = blockToCheckState.m_60734_();
                if (blockToCheck instanceof BucketPickup && !(bucketPickup = (BucketPickup)blockToCheck).m_142598_((LevelAccessor)level, blockToCheckPos, blockToCheckState).m_41619_()) {
                    ++checkedBlocksCount;
                    if (currentRange >= 6) continue;
                    queue.add(new Tuple((Object)blockToCheckPos, (Object)(currentRange + 1)));
                    continue;
                }
                if (!(blockToCheckState.m_60734_() instanceof LiquidBlock)) continue;
                if (blockToCheckState.m_60713_(Blocks.f_50575_) || blockToCheckState.m_60713_(Blocks.f_50576_) || blockToCheckState.m_60713_(Blocks.f_50037_) || blockToCheckState.m_60713_(Blocks.f_50038_)) {
                    BlockEntity blockEntity = blockToCheckState.m_155947_() ? level.m_7702_(blockToCheckPos) : null;
                    IndustrialInsulationBlock.m_49892_((BlockState)blockToCheckState, (LevelAccessor)level, (BlockPos)blockToCheckPos, (BlockEntity)blockEntity);
                }
                this.removeBlock(blockToCheckPos, level);
                ++checkedBlocksCount;
                if (currentRange >= 6) continue;
                queue.add(new Tuple((Object)blockToCheckPos, (Object)(currentRange + 1)));
            }
            if (checkedBlocksCount <= 64) continue;
            break;
        }
    }
}

