/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.modules.tank.blocks;

import java.text.DecimalFormat;
import java.util.Collections;
import java.util.Objects;
import javax.annotation.Nonnull;
import mcjty.deepresonance.modules.generator.GeneratorModule;
import mcjty.deepresonance.modules.tank.TankModule;
import mcjty.deepresonance.modules.tank.data.DRTankHandler;
import mcjty.deepresonance.modules.tank.data.DRTankNetwork;
import mcjty.deepresonance.modules.tank.data.TankBlob;
import mcjty.deepresonance.util.LiquidCrystalData;
import mcjty.lib.multiblock.IMultiblock;
import mcjty.lib.multiblock.IMultiblockConnector;
import mcjty.lib.multiblock.MultiblockDriver;
import mcjty.lib.multiblock.MultiblockSupport;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.varia.ComponentFactory;
import mcjty.lib.varia.Tools;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TankTileEntity
extends GenericTileEntity
implements IMultiblockConnector {
    private int blobId = -1;
    @Nonnull
    private LiquidCrystalData clientRenderFluid = LiquidCrystalData.EMPTY;
    private float renderHeight;
    private FluidStack preservedFluid = FluidStack.EMPTY;
    @Cap(type=CapType.FLUIDS)
    private final DRTankHandler fluidHandler = this.createFluidHandler();

    public TankTileEntity(BlockPos pos, BlockState state) {
        super(TankModule.TYPE_TANK.get(), pos, state);
    }

    public void setClientData(float newHeight, LiquidCrystalData render) {
        boolean dirty = false;
        if (newHeight >= 0.0f && this.renderHeight != newHeight) {
            this.renderHeight = newHeight;
            dirty = true;
        }
        if (!Objects.equals(this.clientRenderFluid, render)) {
            this.clientRenderFluid = LiquidCrystalData.fromStack(render.getFluidStack());
            dirty = true;
        }
        if (dirty) {
            this.markDirtyClient();
        }
    }

    public int getComparatorValue() {
        DRTankHandler handler = this.createFluidHandler();
        float f = (float)handler.getFluidInTank(0).getAmount() / (float)handler.getTankCapacity(0);
        return (int)(f * 15.0f);
    }

    public float getClientRenderHeight() {
        return this.renderHeight;
    }

    @Nonnull
    public Fluid getClientRenderFluid() {
        return this.clientRenderFluid.getFluidStack().getFluid();
    }

    public DRTankHandler getFluidHandler() {
        return this.createFluidHandler();
    }

    public void m_183515_(@Nonnull CompoundTag tagCompound) {
        tagCompound.m_128405_("blobid", this.blobId);
        this.saveClientDataToNBT(tagCompound);
        super.m_183515_(tagCompound);
    }

    protected void saveInfo(CompoundTag tagCompound) {
        super.saveInfo(tagCompound);
        CompoundTag tag = new CompoundTag();
        this.preservedFluid.writeToNBT(tag);
        this.getOrCreateInfo(tagCompound).m_128365_("preserved", (Tag)tag);
    }

    public void m_142466_(CompoundTag tagCompound) {
        this.blobId = tagCompound.m_128441_("blobid") ? tagCompound.m_128451_("blobid") : -1;
        this.loadClientDataFromNBT(tagCompound);
        super.m_142466_(tagCompound);
    }

    protected void loadInfo(CompoundTag tagCompound) {
        super.loadInfo(tagCompound);
        CompoundTag info = tagCompound.m_128469_("Info");
        this.preservedFluid = info.m_128441_("preserved") ? FluidStack.loadFluidStackFromNBT((CompoundTag)info.m_128469_("preserved")) : FluidStack.EMPTY;
    }

    public void saveClientDataToNBT(CompoundTag tagCompound) {
        tagCompound.m_128350_("renderC", this.renderHeight);
        if (!this.clientRenderFluid.isEmpty()) {
            CompoundTag tag = new CompoundTag();
            this.clientRenderFluid.getFluidStack().writeToNBT(tag);
            tagCompound.m_128365_("fluidC", (Tag)tag);
        }
    }

    public void loadClientDataFromNBT(CompoundTag tagCompound) {
        this.renderHeight = tagCompound.m_128457_("renderC");
        if (tagCompound.m_128441_("fluidC")) {
            Tag fluidTag = tagCompound.m_128423_("fluidC");
            if (StringTag.f_129288_.equals(fluidTag.m_6458_())) {
                Fluid fluid = Tools.getFluid((ResourceLocation)new ResourceLocation(fluidTag.m_7916_()));
                this.clientRenderFluid = LiquidCrystalData.fromStack(new FluidStack(fluid, 1));
            } else {
                FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((CompoundTag)((CompoundTag)fluidTag));
                this.clientRenderFluid = LiquidCrystalData.fromStack(fluidStack);
            }
        } else {
            this.clientRenderFluid = LiquidCrystalData.EMPTY;
        }
    }

    public InteractionResult onBlockActivated(BlockState state, Player player, InteractionHand hand, BlockHitResult result) {
        ItemStack itemInHand = player.m_21120_(hand);
        if (FluidUtil.getFluidHandler((ItemStack)itemInHand).isPresent()) {
            if (!this.f_58857_.f_46443_) {
                FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (Level)this.m_58904_(), (BlockPos)result.m_82425_(), (Direction)result.m_82434_());
            }
            return InteractionResult.SUCCESS;
        }
        if (!this.f_58857_.f_46443_) {
            DecimalFormat decimalFormat = new DecimalFormat("#.#");
            FluidStack fluid = this.createFluidHandler().getFluidInTank(0);
            if (fluid.isEmpty()) {
                player.m_213846_((Component)ComponentFactory.literal((String)"Tank is empty").m_130940_(ChatFormatting.YELLOW));
            } else {
                String amount = " (" + fluid.getAmount() + " mb)";
                player.m_213846_((Component)ComponentFactory.literal((String)"Liquid: ").m_7220_((Component)ComponentFactory.translatable((String)fluid.getTranslationKey())).m_7220_((Component)ComponentFactory.literal((String)amount)).m_130940_(ChatFormatting.AQUA));
                if (LiquidCrystalData.isLiquidCrystal(fluid.getFluid())) {
                    LiquidCrystalData d = LiquidCrystalData.fromStack(fluid);
                    player.m_213846_((Component)ComponentFactory.literal((String)("Quality " + decimalFormat.format(d.getQuality() * 100.0) + "%")));
                    player.m_213846_((Component)ComponentFactory.literal((String)("Efficiency " + decimalFormat.format(d.getEfficiency() * 100.0) + "%")));
                    player.m_213846_((Component)ComponentFactory.literal((String)("Purity " + decimalFormat.format(d.getPurity() * 100.0) + "%")));
                    player.m_213846_((Component)ComponentFactory.literal((String)("Strength " + decimalFormat.format(d.getStrength() * 100.0) + "%")));
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void onBlockPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (!world.m_5776_()) {
            CompoundTag tag;
            this.addBlockToNetwork();
            TankBlob network = this.getBlob();
            if (network != null && (tag = stack.m_41783_()) != null) {
                this.getDriver().modify(this.getMultiblockId(), holder -> {
                    CompoundTag infoTag = tag.m_128469_("BlockEntityTag").m_128469_("Info");
                    if (infoTag.m_128441_("preserved")) {
                        FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((CompoundTag)infoTag.m_128469_("preserved"));
                        ((TankBlob)holder.getMb()).fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
                        this.updateHeightsForClient();
                    }
                });
            }
        }
    }

    public void onReplaced(Level world, BlockPos pos, BlockState state, BlockState newstate) {
        if (!world.m_5776_()) {
            BlockState stateDown;
            BlockState stateUp;
            if (newstate.m_60734_() != TankModule.TANK_BLOCK.get()) {
                TankBlob network = this.getBlob();
                if (network != null) {
                    LiquidCrystalData data = network.getData();
                    if (!data.isEmpty()) {
                        this.preservedFluid = data.getFluidStack().copy();
                        int amount = data.getAmount() / network.getTankBlocks();
                        this.preservedFluid.setAmount(amount);
                        data.setAmount(data.getAmount() - amount);
                    } else {
                        this.preservedFluid = FluidStack.EMPTY;
                    }
                    this.m_6596_();
                }
                this.removeBlockFromNetwork();
            }
            if ((stateUp = world.m_8055_(pos.m_7494_())).m_60734_() == GeneratorModule.GENERATOR_PART_BLOCK.get()) {
                world.m_7260_(pos.m_7494_(), stateUp, stateUp, 3);
            }
            if ((stateDown = world.m_8055_(pos.m_7495_())).m_60734_() == GeneratorModule.GENERATOR_PART_BLOCK.get()) {
                world.m_7260_(pos.m_7495_(), stateDown, stateDown, 3);
            }
        }
    }

    public void addBlockToNetwork() {
        TankBlob newMb = new TankBlob().setTankBlocks(1);
        newMb.updateDistribution(Collections.singleton(this.f_58858_));
        MultiblockSupport.addBlock((Level)this.f_58857_, (BlockPos)this.m_58899_(), DRTankNetwork.getNetwork(this.f_58857_).getDriver(), (IMultiblock)newMb);
        this.updateHeightsForClient();
    }

    public void removeBlockFromNetwork() {
        MultiblockSupport.removeBlock((Level)this.f_58857_, (BlockPos)this.m_58899_(), DRTankNetwork.getNetwork(this.f_58857_).getDriver());
    }

    @Nonnull
    public LiquidCrystalData getClientLiquidData() {
        return this.clientRenderFluid;
    }

    private void updateHeightsForClient() {
        int id = this.getMultiblockId();
        if (id != -1) {
            TankBlob blob = this.getBlob();
            LiquidCrystalData data = blob.getData();
            FluidStack fluidStack = data.getFluidStack();
            int amount = fluidStack.getAmount();
            int capacityPerTank = blob.getCapacityPerTank();
            DRTankNetwork.foreach(this.f_58857_, id, blockPos -> {
                BlockEntity be = this.f_58857_.m_7702_(blockPos);
                if (be instanceof TankTileEntity) {
                    float height;
                    int countBelow = blob.getBlocksBelowY(blockPos.m_123342_());
                    int countAtY = blob.getBlocksAtY(blockPos.m_123342_());
                    if (amount <= countBelow * capacityPerTank) {
                        height = 0.0f;
                    } else if (amount > (countBelow + countAtY) * capacityPerTank) {
                        height = 1.0f;
                    } else {
                        height = amount - countBelow * capacityPerTank;
                        height /= (float)(countAtY * capacityPerTank);
                    }
                    ((TankTileEntity)be).setClientData(height, data);
                }
            }, this.f_58858_);
        }
    }

    public ResourceLocation getId() {
        return DRTankNetwork.TANK_NETWORK_ID;
    }

    public int getMultiblockId() {
        return this.blobId;
    }

    public void setMultiblockId(int newId) {
        if (this.blobId != newId) {
            this.blobId = newId;
            this.m_6596_();
        }
    }

    public TankBlob getBlob() {
        if (this.blobId == -1) {
            return null;
        }
        DRTankNetwork network = DRTankNetwork.getNetwork(this.f_58857_);
        return network.getOrCreateBlob(this.blobId);
    }

    private MultiblockDriver<TankBlob> getDriver() {
        return DRTankNetwork.getNetwork(this.f_58857_).getDriver();
    }

    public DRTankHandler getInternalFluidHandler() {
        return this.fluidHandler;
    }

    @Nonnull
    private DRTankHandler createFluidHandler() {
        return new DRTankHandler(this){

            @Override
            public void onUpdate() {
                TankTileEntity.this.updateHeightsForClient();
                TankTileEntity.this.m_6596_();
                DRTankNetwork.getNetwork(TankTileEntity.this.f_58857_).save();
            }
        };
    }
}

