/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.modules.radiation.item;

import mcjty.deepresonance.api.armor.IRadiationArmor;
import mcjty.deepresonance.modules.core.CoreModule;
import mcjty.deepresonance.modules.radiation.item.ResonatingMaterial;
import mcjty.deepresonance.modules.radiation.util.RadiationConfiguration;
import mcjty.deepresonance.setup.Registration;
import mcjty.lib.items.GenericArmorItem;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class ItemRadiationSuit
extends GenericArmorItem
implements IRadiationArmor {
    public static final ArmorMaterial ARMOR_TYPE = new ResonatingMaterial("deepresonance:resonating_armor", 12, new int[]{1, 4, 5, 2}, 12, SoundEvents.f_11673_, 0.5f, 0.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{CoreModule.RESONATING_PLATE_ITEM.get()}));

    public ItemRadiationSuit(EquipmentSlot slot) {
        super(ARMOR_TYPE, slot, Registration.createStandardProperties());
    }

    public static float getRadiationProtection(LivingEntity entity) {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack stack;
            if (slot.m_20743_() != EquipmentSlot.Type.ARMOR || (stack = entity.m_6844_(slot)).m_41619_()) continue;
            int count = ItemRadiationSuit.countSuitPieces(entity);
            if (count <= 0) {
                return 0.0f;
            }
            if (stack.m_41720_() instanceof IRadiationArmor && ((IRadiationArmor)stack.m_41720_()).isActive(stack)) {
                return ((IRadiationArmor)stack.m_41720_()).protection(count);
            }
            if (!stack.m_41782_() || !stack.m_41783_().m_128441_("AntiRadiationArmor")) continue;
            return (float)((Double)RadiationConfiguration.SUIT_PROTECTION[count].get()).doubleValue();
        }
        return 0.0f;
    }

    public static int countSuitPieces(LivingEntity entity) {
        int cnt = 0;
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            if (slot.m_20743_() != EquipmentSlot.Type.ARMOR) continue;
            ItemStack stack = entity.m_6844_(slot);
            if (!stack.m_41619_() && stack.m_41720_() instanceof IRadiationArmor && ((IRadiationArmor)stack.m_41720_()).isActive(stack)) {
                ++cnt;
                continue;
            }
            if (!stack.m_41782_() || !stack.m_41783_().m_128441_("AntiRadiationArmor")) continue;
            ++cnt;
        }
        return cnt;
    }
}

